% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securitylake_operations.R
\name{securitylake_get_data_lake_sources}
\alias{securitylake_get_data_lake_sources}
\title{Retrieves a snapshot of the current Region, including whether Amazon
Security Lake is enabled for those accounts and which sources Security
Lake is collecting data from}
\usage{
securitylake_get_data_lake_sources(
  accounts = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{accounts}{The Amazon Web Services account ID for which a static snapshot of the
current Amazon Web Services Region, including enabled accounts and log
sources, is retrieved.}

\item{maxResults}{The maximum limit of accounts for which the static snapshot of the
current Region, including enabled accounts and log sources, is
retrieved.}

\item{nextToken}{Lists if there are more results available. The value of nextToken is a
unique pagination token for each page. Repeat the call using the
returned token to retrieve the next page. Keep all other arguments
unchanged.

Each pagination token expires after 24 hours. Using an expired
pagination token will return an HTTP 400 InvalidToken error.}
}
\description{
Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts and which sources Security Lake is collecting data from.

See \url{https://www.paws-r-sdk.com/docs/securitylake_get_data_lake_sources/} for full documentation.
}
\keyword{internal}
