% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_policy_versions}
\alias{iam_list_policy_versions}
\title{Lists information about the versions of the specified managed policy,
including the version that is currently set as the policy's default
version}
\usage{
iam_list_policy_versions(PolicyArn, Marker = NULL, MaxItems = NULL)
}
\arguments{
\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy for which you want the
versions.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Lists information about the versions of the specified managed policy, including the version that is currently set as the policy's default version.

See \url{https://www.paws-r-sdk.com/docs/iam_list_policy_versions/} for full documentation.
}
\keyword{internal}
