% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_checkout_borrow_license}
\alias{licensemanager_checkout_borrow_license}
\title{Checks out the specified license for offline use}
\usage{
licensemanager_checkout_borrow_license(
  LicenseArn,
  Entitlements,
  DigitalSignatureMethod,
  NodeId = NULL,
  CheckoutMetadata = NULL,
  ClientToken
)
}
\arguments{
\item{LicenseArn}{[required] Amazon Resource Name (ARN) of the license. The license must use the
borrow consumption configuration.}

\item{Entitlements}{[required] License entitlements. Partial checkouts are not supported.}

\item{DigitalSignatureMethod}{[required] Digital signature method. The possible value is JSON Web Signature (JWS)
algorithm PS384. For more information, see \href{https://datatracker.ietf.org/doc/html/rfc7518#section-3.5}{RFC 7518 Digital Signature with RSASSA-PSS}.}

\item{NodeId}{Node ID.}

\item{CheckoutMetadata}{Information about constraints.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Checks out the specified license for offline use.

See \url{https://www.paws-r-sdk.com/docs/licensemanager_checkout_borrow_license/} for full documentation.
}
\keyword{internal}
