% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_query_definition}
\alias{cloudwatchlogs_put_query_definition}
\title{Creates or updates a query definition for CloudWatch Logs Insights}
\usage{
cloudwatchlogs_put_query_definition(
  queryLanguage = NULL,
  name,
  queryDefinitionId = NULL,
  logGroupNames = NULL,
  queryString,
  clientToken = NULL
)
}
\arguments{
\item{queryLanguage}{Specify the query language to use for this query. The options are Logs
Insights QL, OpenSearch PPL, and OpenSearch SQL. For more information
about the query languages that CloudWatch Logs supports, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html}{Supported query languages}.}

\item{name}{[required] A name for the query definition. If you are saving numerous query
definitions, we recommend that you name them. This way, you can find the
ones you want by using the first part of the name as a filter in the
\code{queryDefinitionNamePrefix} parameter of
\code{\link[=cloudwatchlogs_describe_query_definitions]{describe_query_definitions}}.}

\item{queryDefinitionId}{If you are updating a query definition, use this parameter to specify
the ID of the query definition that you want to update. You can use
\code{\link[=cloudwatchlogs_describe_query_definitions]{describe_query_definitions}}
to retrieve the IDs of your saved query definitions.

If you are creating a query definition, do not specify this parameter.
CloudWatch generates a unique ID for the new query definition and
include it in the response to this operation.}

\item{logGroupNames}{Use this parameter to include specific log groups as part of your query
definition. If your query uses the OpenSearch Service query language,
you specify the log group names inside the \code{querystring} instead of
here.

If you are updating an existing query definition for the Logs Insights
QL or OpenSearch Service PPL and you omit this parameter, then the
updated definition will contain no log groups.}

\item{queryString}{[required] The query string to use for this definition. For more information, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html}{CloudWatch Logs Insights Query Syntax}.}

\item{clientToken}{Used as an idempotency token, to avoid returning an exception if the
service receives the same request twice because of a network error.}
}
\description{
Creates or updates a query definition for CloudWatch Logs Insights. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html}{Analyzing Log Data with CloudWatch Logs Insights}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_query_definition/} for full documentation.
}
\keyword{internal}
