% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchinternetmonitor_operations.R
\name{cloudwatchinternetmonitor_create_monitor}
\alias{cloudwatchinternetmonitor_create_monitor}
\title{Creates a monitor in Amazon CloudWatch Internet Monitor}
\usage{
cloudwatchinternetmonitor_create_monitor(
  MonitorName,
  Resources = NULL,
  ClientToken = NULL,
  Tags = NULL,
  MaxCityNetworksToMonitor = NULL,
  InternetMeasurementsLogDelivery = NULL,
  TrafficPercentageToMonitor = NULL,
  HealthEventsConfig = NULL
)
}
\arguments{
\item{MonitorName}{[required] The name of the monitor.}

\item{Resources}{The resources to include in a monitor, which you provide as a set of
Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon
CloudFront distributions, or Amazon WorkSpaces directories.

You can add a combination of VPCs and CloudFront distributions, or you
can add WorkSpaces directories, or you can add NLBs. You can't add NLBs
or WorkSpaces directories together with any other resources.

If you add only Amazon VPC resources, at least one VPC must have an
Internet Gateway attached to it, to make sure that it has internet
connectivity.}

\item{ClientToken}{A unique, case-sensitive string of up to 64 ASCII characters that you
specify to make an idempotent API request. Don't reuse the same client
token for other API requests.}

\item{Tags}{The tags for a monitor. You can add a maximum of 50 tags in Internet
Monitor.}

\item{MaxCityNetworksToMonitor}{The maximum number of city-networks to monitor for your resources. A
city-network is the location (city) where clients access your
application resources from and the ASN or network provider, such as an
internet service provider (ISP), that clients access the resources
through. Setting this limit can help control billing costs.

To learn more, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html}{Choosing a city-network maximum value}
in the Amazon CloudWatch Internet Monitor section of the \emph{CloudWatch
User Guide}.}

\item{InternetMeasurementsLogDelivery}{Publish internet measurements for Internet Monitor to an Amazon S3
bucket in addition to CloudWatch Logs.}

\item{TrafficPercentageToMonitor}{The percentage of the internet-facing traffic for your application that
you want to monitor with this monitor. If you set a city-networks
maximum, that limit overrides the traffic percentage that you set.

To learn more, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html}{Choosing an application traffic percentage to monitor}
in the Amazon CloudWatch Internet Monitor section of the \emph{CloudWatch
User Guide}.}

\item{HealthEventsConfig}{Defines the threshold percentages and other configuration information
for when Amazon CloudWatch Internet Monitor creates a health event.
Internet Monitor creates a health event when an internet issue that
affects your application end users has a health score percentage that is
at or below a specific threshold, and, sometimes, when other criteria
are met.

If you don't set a health event threshold, the default value is 95\%.

For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview}{Change health event thresholds}
in the Internet Monitor section of the \emph{CloudWatch User Guide}.}
}
\description{
Creates a monitor in Amazon CloudWatch Internet Monitor. A monitor is built based on information from the application resources that you add: VPCs, Network Load Balancers (NLBs), Amazon CloudFront distributions, and Amazon WorkSpaces directories. Internet Monitor then publishes internet measurements from Amazon Web Services that are specific to the \emph{city-networks}. That is, the locations and ASNs (typically internet service providers or ISPs), where clients access your application. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-InternetMonitor.html}{Using Amazon CloudWatch Internet Monitor} in the \emph{Amazon CloudWatch User Guide}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_create_monitor/} for full documentation.
}
\keyword{internal}
