% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_rule}
\alias{connect_update_rule}
\title{Updates a rule for the specified Amazon Connect instance}
\usage{
connect_update_rule(RuleId, InstanceId, Name, Function, Actions, PublishStatus)
}
\arguments{
\item{RuleId}{[required] A unique identifier for the rule.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Name}{[required] The name of the rule. You can change the name only if
\code{TriggerEventSource} is one of the following values:
\code{OnZendeskTicketCreate} | \code{OnZendeskTicketStatusUpdate} |
\code{OnSalesforceCaseCreate}}

\item{Function}{[required] The conditions of the rule.}

\item{Actions}{[required] A list of actions to be run when the rule is triggered.}

\item{PublishStatus}{[required] The publish status of the rule.}
}
\description{
Updates a rule for the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_update_rule/} for full documentation.
}
\keyword{internal}
