% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_security_profile}
\alias{connect_create_security_profile}
\title{Creates a security profile}
\usage{
connect_create_security_profile(
  SecurityProfileName,
  Description = NULL,
  Permissions = NULL,
  InstanceId,
  Tags = NULL,
  AllowedAccessControlTags = NULL,
  TagRestrictedResources = NULL,
  Applications = NULL,
  HierarchyRestrictedResources = NULL,
  AllowedAccessControlHierarchyGroupId = NULL
)
}
\arguments{
\item{SecurityProfileName}{[required] The name of the security profile.}

\item{Description}{The description of the security profile.}

\item{Permissions}{Permissions assigned to the security profile. For a list of valid
permissions, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html}{List of security profile permissions}.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}

\item{AllowedAccessControlTags}{The list of tags that a security profile uses to restrict access to
resources in Amazon Connect.}

\item{TagRestrictedResources}{The list of resources that a security profile applies tag restrictions
to in Amazon Connect. For a list of Amazon Connect resources that you
can tag, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/tagging.html}{Add tags to resources in Amazon Connect}
in the \emph{Amazon Connect Administrator Guide}.}

\item{Applications}{A list of third-party applications that the security profile will give
access to.}

\item{HierarchyRestrictedResources}{The list of resources that a security profile applies hierarchy
restrictions to in Amazon Connect. Following are acceptable
ResourceNames: \code{User}.}

\item{AllowedAccessControlHierarchyGroupId}{The identifier of the hierarchy group that a security profile uses to
restrict access to resources in Amazon Connect.}
}
\description{
Creates a security profile.

See \url{https://www.paws-r-sdk.com/docs/connect_create_security_profile/} for full documentation.
}
\keyword{internal}
