% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_contact}
\alias{connect_create_contact}
\title{Only the EMAIL channel is supported}
\usage{
connect_create_contact(
  InstanceId,
  ClientToken = NULL,
  RelatedContactId = NULL,
  Attributes = NULL,
  References = NULL,
  Channel,
  InitiationMethod,
  ExpiryDurationInMinutes = NULL,
  UserInfo = NULL,
  InitiateAs = NULL,
  Name = NULL,
  Description = NULL,
  SegmentAttributes = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{RelatedContactId}{The identifier of the contact in this instance of Amazon Connect.}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in flows just
like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}

\item{References}{A formatted URL that is shown to an agent in the Contact Control Panel
(CCP). Tasks can have the following reference types at the time of
creation: URL | NUMBER | STRING | DATE | EMAIL | ATTACHMENT.}

\item{Channel}{[required] The channel for the contact

CreateContact only supports the EMAIL channel. The following information
that states other channels are supported is incorrect. We are working to
update this topic.}

\item{InitiationMethod}{[required] Indicates how the contact was initiated.

CreateContact only supports the following initiation methods: OUTBOUND,
AGENT_REPLY, and FLOW. The following information that states other
initiation methods are supported is incorrect. We are working to update
this topic.}

\item{ExpiryDurationInMinutes}{Number of minutes the contact will be active for before expiring}

\item{UserInfo}{User details for the contact}

\item{InitiateAs}{Initial state of the contact when it's created}

\item{Name}{The name of a the contact.}

\item{Description}{A description of the contact.}

\item{SegmentAttributes}{A set of system defined key-value pairs stored on individual contact
segments (unique contact ID) using an attribute map. The attributes are
standard Amazon Connect attributes. They can be accessed in flows.

Attribute keys can include only alphanumeric, -, and _.

This field can be used to set Segment Contact Expiry as a duration in
minutes.

To set contact expiry, a ValueMap must be specified containing the
integer number of minutes the contact will be active for before
expiring, with \code{SegmentAttributes} like \{
\verb{ "connect:ContactExpiry": \\\{"ValueMap" : \\\{ "ExpiryDuration": \\\{ "ValueInteger": 135\\\}\\\}\\\}\\\}}.}
}
\description{
Only the EMAIL channel is supported. The supported initiation methods are: OUTBOUND, AGENT_REPLY, and FLOW.

See \url{https://www.paws-r-sdk.com/docs/connect_create_contact/} for full documentation.
}
\keyword{internal}
