% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udfs.R
\name{tx_subsumed_by}
\alias{tx_subsumed_by}
\title{Test subsumption between codings}
\usage{
tx_subsumed_by(left_codings, right_codings)
}
\arguments{
\item{left_codings}{A Column containing a struct representation of a Coding or an array of Codings.}

\item{right_codings}{A Column containing a struct representation of a Coding or an array of Codings.}
}
\value{
A Column containing the result of the operation (boolean).
}
\description{
Takes two Coding columns as input. Returns a Column that contains a Boolean value,
indicating whether the left Coding is subsumed by the right Coding.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) withAutoprint(\{ # examplesIf}
pc <- pathling_connect()

# Test the codings of the Condition `code` for subsumption by a SNOMED CT code.
pc \%>\%
  pathling_example_resource("Condition") \%>\%
  sparklyr::mutate(
    id,
    is_subsumed_by = !!tx_subsumed_by(
      code[["coding"]],
      !!tx_to_snomed_coding("444814009")
    ),
    .keep = "none"
  )

pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/terminology#subsumption-testing}{Pathling documentation - Subsumption testing}

Other terminology functions: 
\code{\link{tx_display}()},
\code{\link{tx_member_of}()},
\code{\link{tx_property_of}()},
\code{\link{tx_subsumes}()},
\code{\link{tx_translate}()}
}
\concept{terminology functions}
