% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informationtheory_based.R
\name{normalizedMutualInformation}
\alias{normalizedMutualInformation}
\alias{normalizedMutualInformation,Partition,Partition,character-method}
\alias{normalizedMutualInformation,Partition,Partition,missing-method}
\title{Normalized Mutual Information}
\usage{
normalizedMutualInformation(p, q, type = c("min", "max", "sum"))

\S4method{normalizedMutualInformation}{Partition,Partition,character}(p, q, type = c("min", "max", "sum"))

\S4method{normalizedMutualInformation}{Partition,Partition,missing}(p, q, type = NULL)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}

\item{type}{One of "min" (default), "max" or "sum"}
}
\description{
Compute the mutual information (\eqn{MI}) which is normalized either by the
minimum/maximum partition entropy (\eqn{H})
\deqn{\frac{MI(P, Q)}{\varphi(H(P), H(Q))},\ \varphi \in \{\min, \max\}}
or the sum
\deqn{\frac{2 \cdot MI(P, Q)}{H(P) + H(Q)}}
}
\section{Methods (by class)}{
\itemize{
\item \code{normalizedMutualInformation(p = Partition, q = Partition, type = character)}: Compute given two partitions

\item \code{normalizedMutualInformation(p = Partition, q = Partition, type = missing)}: Compute given two partitions with \code{type="min"}

}}
\examples{
isTRUE(all.equal(normalizedMutualInformation(
                   new("Partition", c(0, 0, 0, 1, 1)),
                   new("Partition", c(0, 0, 1, 1, 1)), "min"),
                 normalizedMutualInformation(
                   new("Partition", c(0, 0, 0, 1, 1)), 
                   new("Partition", c(0, 0, 1, 1, 1)), "max")
                 ))

}
\references{
\insertRef{Kvalseth1987}{partitionComparison}
}
\seealso{
\code{\link{mutualInformation}}, \code{\link{entropy}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
