% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{\%or\%}
\alias{\%or\%}
\title{Applying alternative parsers}
\usage{
p1 \%or\% p2
}
\arguments{
\item{p1, p2}{two parsers.}
}
\value{
A parser.
}
\description{
The \verb{\%or\%} combinator \code{(p1 \%or\% p2)} returns the result of \code{p1} if \code{p1} is
successful or, if \code{p1} fails that of \code{p2} if \code{p2} parses successfully,
otherwise it returns a \code{fail}.
}
\section{Pseudocode}{

\preformatted{
(p1 \%or\% p2)(x):
  if p1(x)==[] then
    if p2(x)==[] then fail()(x) else p2(x)
  else p1(x)
}

where \verb{[]} is the empty list.
}

\examples{
(literal("A") \%or\% literal("a"))(LETTERS[1:5]) # success on first parser
(literal("A") \%or\% literal("a"))(letters[1:5]) # success on second parser
(literal("A") \%or\% literal("a"))(LETTERS[2:6]) # failure
starts_with_a <- function(x) grepl("^a",x[1])
# success on both parsers, but returns result of p1 only
(literal("a") \%or\% satisfy(starts_with_a)) (letters[1:5])

}
