% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-list.R
\name{pandoc_list_formats}
\alias{pandoc_list_formats}
\title{List available supported formats}
\usage{
pandoc_list_formats(type = c("input", "output"), version = "default")
}
\arguments{
\item{type}{Either list \code{input} or \code{output} formats. It corresponds to call
\code{--list-input-formats} and \code{--list-output-formats} respectively.}

\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
a data.frame (or a tibble if available) with 2 column:
\itemize{
\item \code{type} (input or output)
\item \code{formats} (name of the formats that can be used as input or output)
}
}
\description{
List available supported formats
}
\examples{
\dontshow{if (pandoc_available("1.18")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# which input formats are available
pandoc_list_formats()
# which output formats are available
pandoc_list_formats()
\dontshow{\}) # examplesIf}
\dontshow{if (!is.null(pandoc::pandoc_system_bin()) && pandoc_system_version() > "1.18") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# target a specific version
pandoc_list_formats("input", version = "system")
\dontshow{\}) # examplesIf}
}
