% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Insol.R
\name{Insol}
\alias{Insol}
\title{Computes incoming solar radiation (insolation)}
\usage{
Insol(orbit, long = pi/2, lat = 65 * pi/180, S0 = 1365, H = NULL)
}
\arguments{
\item{orbit}{Output from a solution, such as \code{ber78}, \code{ber90} or
\code{la04}}

\item{long}{true solar longitude}

\item{lat}{latitude}

\item{S0}{Total solar irradiance}

\item{H}{Sun hour angle, in radians}
}
\value{
Daily-mean insolation (assuming fixed astronomical parameters during
a true solar day) if `H` is null.  Otherwise, insolation at specified hour
angle (H = 0 at noon, H = pi at midnight).
}
\description{
Computes incoming solar radiation (insolation) for a given astronomical
configuration, true solar longitude and latitude
}
\details{
True solar longitude is measured in radians: \tabular{ll}{ pi/2 \tab for
June solstice\cr pi \tab for September equinox\cr 3 * pi/2 \tab for December
solstice\cr 0 \tab for Spring equinox\cr } It may be obtained for a given
day in the year using the function \code{day2l}.
}
\examples{


## make a little wrapper, with all default values

insolation <- function(times, astrosol=ber78,...)
  sapply(times, function(tt) Insol(orbit=astrosol(tt)))

tts <- seq(from = -400e3, to = 0, by = 1e3)
isl <- insolation(tts, ber78)
plot(tts, isl, typ='l')


}
\references{
Berger, A. L. (1978).  Long-term variations of daily insolation
and Quaternary climatic changes, J. Atmos. Sci., 35, 2362-2367.
}
\author{
Michel Crucifix, U. catholique de Louvain, Belgium.
}
\keyword{misc}
