% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonTable2TaxonTree.R
\name{taxonTable2taxonTree}
\alias{taxonTable2taxonTree}
\title{Create a Taxonomy-Based Phylogeny ('Taxon Tree') from a Hierarchical Table of Taxonomy Memberships}
\usage{
taxonTable2taxonTree(taxonTable, cleanTree = TRUE, rootLabel = "root")
}
\arguments{
\item{taxonTable}{A matrix of type character and multiple rows and columns, containing the
tip taxa in the last column, one per row, with progressively larger taxa listed in prior
columns (reading left-to-right). Invariant columns (i.e. taxa that all
tip taxa are in) are allowed, but all but the most 'shallow' of such invariant taxa are
dropped prior to transformation to a taxon-tree phylogeny object.}

\item{cleanTree}{When \code{TRUE} (the default), the tree is run through a series of
post-processing, including having singles collapsed,
nodes reordered and being written out as a Newick string and read
back in, to ensure functionality with ape functions
and ape-derived functions. 
If \code{FALSE}, none of this post-processing is done and
users should beware, as such trees can lead to hard-crashes of R.}

\item{rootLabel}{If the lowest constant/shared level in the taxonomic hierarchy
isn't labeled, what label should be given to this level? The default is \code{"root"}.}
}
\value{
A phylogeny of class \code{phylo}, where each tip is a taxon listed in the last column of the
input \code{taxonTable}. Edges are scaled so that
the distance from one taxon rank to another rank is one unit, 
then merged to remove singleton nodes. 
As not all taxa have parents at the immediate taxon level above, this leads to some odd cases. 
For example, two genera emanating from a node representing a class 
but with a very short (length = 1) branch
and a long branch (length = 3) means one genus is simply placed in the class, 
with no family or order listed while the one on the long branch 
is within an order and family that is otherwise monogeneric.

The names of higher taxa than the tips should be appended as the element $node.label for the internal nodes.
}
\description{
This function takes a matrix of taxon names,
indicating a set of hierarchical taxonomic relationships
conveyed as nested placements for a set of tip-taxa (listed in
the last column of the matrix) and returns
a 'taxonomy-tree' phylogeny object of class \code{phylo}.
}
\details{
This function can deal with empty entries in cells of \code{taxonTable} by assuming these
are lower-level taxa which are 'floating' freely somewhere in
taxa several levels higher.
}
\examples{

# let's create a small, really cheesy example
pokeTable <- rbind(cbind("Pokezooa","Shelloidea","Squirtadae",
     c("Squirtle","Blastoise","Wartortle")),
     c("Pokezooa","Shelloidea","","Lapras"),
     c("Pokezooa","","","Parasect"),
     cbind("Pokezooa","Hirsutamona","Rodentapokemorpha",
     c("Linoone","Sandshrew","Pikachu")),
     c("Pokezooa","Hirsutamona",NA,"Ursaring"))

pokeTree <- taxonTable2taxonTree(pokeTable)

plot(pokeTree)
nodelabels(pokeTree$node.label)

}
\seealso{
\code{\link{makePBDBtaxonTree}}, \code{\link{parentChild2taxonTree}}
}
\author{
David W. Bapst
}
