% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lat_bins_area.R
\name{lat_bins_area}
\alias{lat_bins_area}
\title{Generate equal-area latitudinal bins}
\usage{
lat_bins_area(n = 12, min = -90, max = 90, r = 6371, plot = FALSE)
}
\arguments{
\item{n}{\code{numeric}. A single numeric value defining the number of
equal-area latitudinal bins to split the latitudinal range into (as
defined by \code{min} and \code{max}).}

\item{min}{\code{numeric}. A single numeric value defining the lower limit
of the latitudinal range (defaults to -90).}

\item{max}{\code{numeric}. A single numeric value defining the upper limit
of the latitudinal range (defaults to 90).}

\item{r}{\code{numeric}. The radius of the Earth in kilometres. Defaults to
the volumetric mean radius of the Earth (6371 km). Other user-specified
\code{r} values are accepted (e.g. equatorial radius 6378 km).}

\item{plot}{\code{logical}. Should a plot of the latitudinal bins be
generated? If \code{TRUE}, a plot is generated. Defaults to \code{FALSE}.}
}
\value{
A \code{data.frame} of user-defined number of latitudinal bins. The
\code{data.frame} contains the following columns: bin (bin number), min
(minimum latitude of the bin), mid (midpoint latitude of the bin),
max (maximum latitude of the bin), area (the area of the bin in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}), area_prop (the
proportional area of the bin across all bins).
}
\description{
A function to generate approximately equal-area latitudinal bins for a
user-specified number of bins and latitudinal range. This approach is
based on calculating the curved surface area of spherical segments bounded
by two parallel discs.
}
\section{Developer(s)}{

Lewis A. Jones & Kilian Eichenseer
}

\section{Reviewer(s)}{

Kilian Eichenseer & Bethany Allen
}

\examples{
# Generate 12 latitudinal bins
bins <- lat_bins_area(n = 12)
# Generate latitudinal bins for just the (sub-)tropics
bins <- lat_bins_area(n = 6, min = -30, max = 30)
# Generate latitudinal bins and a plot
bins <- lat_bins_area(n = 24, plot = TRUE)
}
\seealso{
For bins with unequal area, but equal latitudinal range, see
\link{lat_bins_degrees}.
}
