% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_consistency.R
\name{compute_reverse_consistency}
\alias{compute_reverse_consistency}
\title{Compute consistency between forward and reverse pair comparisons}
\usage{
compute_reverse_consistency(main_results, reverse_results)
}
\arguments{
\item{main_results}{A data frame or tibble containing pairwise
comparison results for the "forward" ordering of pairs, with
columns \code{ID1}, \code{ID2}, and \code{better_id}.}

\item{reverse_results}{A data frame or tibble containing results
for the corresponding "reverse" ordering, with the same column
requirements.}
}
\value{
A list with two elements:
\itemize{
\item \code{summary}: a tibble with one row and columns
\code{n_pairs}, \code{n_consistent}, and \code{prop_consistent}.
\item \code{details}: a tibble with one row per overlapping pair,
including columns \code{key}, \code{ID1_main}, \code{ID2_main},
\code{ID1_rev}, \code{ID2_rev}, \code{better_id_main},
\code{better_id_rev}, and \code{is_consistent}.
}
Pairs for which \code{better_id} is \code{NA} in either data
frame are excluded from the consistency calculation.
}
\description{
Given two data frames of pairwise comparison results (one for
the "forward" ordering of pairs, one for the "reverse" ordering),
this function identifies pairs that were evaluated in both orders
and computes the proportion of consistent judgments.
}
\details{
Consistency is defined at the level of IDs: a pair is consistent
if the same ID is selected as better in both data frames. This
assumes that each result data frame contains at least the columns
\code{ID1}, \code{ID2}, and \code{better_id}, where
\code{better_id} is the ID of the better sample (not
"SAMPLE_1"/"SAMPLE_2").
}
\examples{
# Simple synthetic example
main <- tibble::tibble(
  ID1       = c("S1", "S1", "S2"),
  ID2       = c("S2", "S3", "S3"),
  better_id = c("S1", "S3", "S2")
)

rev <- tibble::tibble(
  ID1       = c("S2", "S3", "S3"),
  ID2       = c("S1", "S1", "S2"),
  better_id = c("S1", "S3", "S2")
)

rc <- compute_reverse_consistency(main, rev)
rc$summary

# Using the example writing pairs to reverse the first 10 pairs
data("example_writing_pairs")
main2 <- example_writing_pairs[1:10, ]
rev2 <- main2
rev2$ID1 <- main2$ID2
rev2$ID2 <- main2$ID1
rc2 <- compute_reverse_consistency(main2, rev2)
rc2$summary

}
