% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thicken_cust.R
\name{thicken_cust}
\alias{thicken_cust}
\title{Thicken with a custom spanning}
\usage{
thicken_cust(x, spanned, colname, by = NULL, drop = FALSE)
}
\arguments{
\item{x}{A data frame containing at least one datetime variable of
class \code{Date}, \code{POSIXct} or \code{POSIXlt}.}

\item{spanned}{A datetime vector to which the the datetime variable in
\code{x} should be mapped.}

\item{colname}{Character, the column name of the added variable.}

\item{by}{Only needs to be specified when \code{x} contains multiple
variables of class \code{Date}, \code{POSIXct} or \code{POSIXlt}.
Indicates which to use for thickening.}

\item{drop}{Should the original datetime variable be dropped from the
returned data frame? Defaults to \code{FALSE}.}
}
\value{
The data frame \code{x} with the variable added to it.
}
\description{
Like \code{thicken}, it will find the datetime variable in \code{x}
and add a variable of a higher periodicity to it. However, the variable to
which to map the observation is provided by the user. This enables mapping to
time points that are unequally spaced.
}
\details{
Only rounding down is available for custom thickening.
}
\examples{
library(dplyr)
# analysis of traffic accidents in traffic jam hours and other hours.
accidents <- emergency \%>\% filter(title == "Traffic: VEHICLE ACCIDENT -")
spanning <- span_time("20151210 16", "20161017 17", tz = "EST") \%>\%
  subset_span(list(hour = c(6, 9, 16, 19)))
thicken_cust(accidents, spanning, "period") \%>\%
  count(period) \%>\%
  pad_cust(spanning)
}
