% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.data.R
\docType{data}
\name{scenario_demo_2020}
\alias{scenario_demo_2020}
\title{A prepared climate scenario dataset for demonstration}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1512 rows and 8 columns.
}
\usage{
scenario_demo_2020
}
\description{
Fake climate scenario dataset, prepared for the software PACTA (Paris
Agreement Capital Transition Assessment). It imitates climate scenario data
(e.g. from the International Energy Agency (IEA)) including the change
through time in production across industrial sectors.

Demo datasets are synthetic because most financial data is strictly private;
they help to demonstrate and test the implementation in R of 'PACTA'
(\url{https://www.transitionmonitor.com/}).
}
\section{Definitions}{


\itemize{
\item \code{region} (character): The region to which the pathway is relevant., * \code{scenario} (character): The name of the scenario., * \code{scenario_source} (character): The source publication from which the scenario was taken., * \code{sector} (character): The sector to which the scenario prescribes a pathway., * \code{smsp} (double): Sector market share percentage of the pathway calculated in 2020., * \code{technology} (character): The technology within the sector to which the scenario prescribes a pathway., * \code{tmsr} (double): Technology market share ratio of the pathway calculated in 2020., * \code{year} (integer): The year at which the pathway value is prescribed.
}

}

\examples{
head(scenario_demo_2020)
}
\seealso{
Other demo data: 
\code{\link{abcd_demo}},
\code{\link{co2_intensity_scenario_demo}},
\code{\link{loanbook_demo}},
\code{\link{market_share_demo}},
\code{\link{overwrite_demo}},
\code{\link{region_isos_demo}},
\code{\link{sda_demo}}
}
\concept{demo data}
\keyword{datasets}
