% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtw.R
\name{run_dtw}
\alias{run_dtw}
\title{Get network adjacency dataframe based on DTW method}
\usage{
run_dtw(
  expression_matrix,
  pseudotime_list,
  slide_window_size = 50,
  slide_step_size = 25,
  quantile_cutoff = 5,
  cores = 1
)
}
\arguments{
\item{expression_matrix}{expression matrix data}

\item{pseudotime_list}{list of pseudotime}

\item{slide_window_size}{sliding window size}

\item{slide_step_size}{sliding window step size}

\item{quantile_cutoff}{an integer value (1-99) for quantile cutoff}

\item{cores}{number of cores for parallel computing}
}
\value{
adjacency dataframe (with columns "from, to, distance,direction, similarity")
}
\description{
Use DTW to calcuate gene-gene distance based on their expression and pseudotime
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
adj_df <- run_dtw(expression_matrix,
                  pseudotime_list,
                  quantile_cutoff=50,
                  cores=1)
                  
}
