% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxcAARCalibratedDate.R
\name{oxcAARCalibratedDate}
\alias{oxcAARCalibratedDate}
\title{oxcAAR Calibrated Dates Object}
\usage{
oxcAARCalibratedDate(
  name,
  type,
  bp,
  std,
  cal_curve,
  sigma_ranges,
  raw_probabilities,
  posterior_probabilities = NA,
  posterior_sigma_ranges = NA
)
}
\arguments{
\item{name}{A string giving the name of the date (usually the lab number).}

\item{type}{A string giving the type of the date in OxCal terminology (e.g. "R_Date", "R_Simulate").}

\item{bp}{An integer/numeric giving the uncalibrated BP value.}

\item{std}{An integer/numeric giving the standard deviation.}

\item{cal_curve}{A list with calibration curve information (name, resolution, bp, bc, sigma).}

\item{sigma_ranges}{A list of three elements (one, two, three sigma), each a data frame
with columns \code{start}, \code{end}, \code{probability}.}

\item{raw_probabilities}{A data frame with columns \code{dates} and \code{probabilities}.}

\item{posterior_probabilities}{A data frame with columns \code{dates} and \code{probabilities},
or \code{NA} if not available.}

\item{posterior_sigma_ranges}{A list of three elements (one, two, three sigma), each a data frame
with columns \code{start}, \code{end}, \code{probability}, or \code{NA} if not available.}
}
\value{
An object of class \code{"oxcAARCalibratedDate"}.
}
\description{
The function \code{oxcAARCalibratedDate()} creates an object representing a single
calibrated radiocarbon date (and optionally its posterior, if a model was run in OxCal).
}
