% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osum.options.R
\name{osum.options}
\alias{osum.options}
\title{Options Settings for Package \code{osum}}
\usage{
osum.options(
  osum.data.class.width,
  osum.format.extent,
  osum.information,
  osum.max.rows
)
}
\arguments{
\item{osum.data.class.width}{integer indicating the width of the \code{data.class} field when
it is a list (when \code{objects.summary} was called with \code{all.classes} = \code{TRUE}).}

\item{osum.format.extent}{logical indicating whether the \code{extent} field should be formatted as
product (d1 x d2) or left as list (d1, d2). Default: TRUE}

\item{osum.information}{character vector specifying what information to return by default. This can be any subset of
\code{c("data.class", "storage.mode", "mode", "typeof", "extent", "object.size")}, in any order.
The default is to return all six types of information, in the order shown.
\code{osum.information} is subject to partial matching, that is, only enough initial letters of each
string element are needed to guarantee unique recognition.}

\item{osum.max.rows}{integer, maximal number of rows to print.}
}
\value{
For \code{osum.options()}, a list of all the \code{osum} package options sorted by name.
For \code{osum.options(name)}, a list of length one containing the set value, or
\code{NULL} if it is unset.  For uses setting one or more options, a list
with the previous values of the options changed (returned invisibly).
}
\description{
This function enables users to customize and review specific \emph{options}
for the \code{osum} package.
}
\details{
Invoking \code{osum.options()} with no arguments returns a list with the current
values of the \code{osum} package options.
To access the value of a single option, one can pass a character string with its
name name as argument, e.g. \code{osum.options("osum.max.rows")}, which will return a named
\emph{list} of length one with the option's value.
}
\examples{
old_opt <- osum.options(osum.data.class.width = 12, osum.max.rows = 25)
cat("current values of all 'osum' options:", sep = "\n")
print(osum.options())
cat("previous values of the changed 'osum' options:", sep = "\n")
print(old_opt)
}
\seealso{
\code{\link{options}} for global \emph{options},
\code{\link{print.objects.summary}} and \code{\link{summary.objects.summary}} for
using specific \code{osum} package options.
}
