% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.summary.R
\encoding{UTF-8}
\name{objects.summary}
\alias{objects.summary}
\title{Summary Information About R Objects}
\usage{
objects.summary(where, all.objects = FALSE, pattern, names. = NULL,
    what = getOption("osum.information", default = c("data.class", "storage.mode",
        "mode", "typeof", "extent", "object.size")),
    all.classes = FALSE, data.class. = NULL, storage.mode. = NULL, mode. = NULL,
    typeof. = NULL, filter., order., reverse = FALSE)
}
\arguments{
\item{where}{which environment to use in listing the available objects.
Defaults to the \emph{current} environment. This argument can specify the environment
in any form; see the \sQuote{Details} section.}

\item{all.objects}{a logical value. If \code{TRUE}, information for all objects is
returned. If \code{FALSE}, the information about objects whose names begin with a \samp{.}
is omitted. Default: FALSE}

\item{pattern}{an optional \link{regular expression}.  Only names matching
\code{pattern} are returned.  \code{\link{glob2rx}} can be used to convert
wildcard patterns to regular expressions.}

\item{names.}{an optional character vector naming objects to summarize. Default: NULL}

\item{what}{character vector specifying what information to return. This can be any subset of
\code{c("data.class", "storage.mode", "mode", "typeof", "extent", "object.size")}, in any order.
The default is to return all six types of information, in the order shown.
\code{what} is subject to partial matching, that is, only enough initial letters of each
string element are needed to guarantee unique recognition.}

\item{all.classes}{logical flag specifying whether the entire class vector of an object
or just the first element should be used, both in selection based on argument \code{data.class}
and in the returned summary. This has bearing only on objects with a class attribute.
By default only the first class element is used.}

\item{data.class.}{character vector of data classes (see \code{\link{data.class}}). Selects objects belonging to one of the named data classes.
If \code{all.classes=TRUE}, each element of an object's class attribute is considered, not just the first.}

\item{storage.mode.}{character vector of storage modes (see \code{\link{storage.mode}}). Selects objects with one of the named storage modes.}

\item{mode.}{character vector of modes (see \code{\link{mode}}). Selects objects with one of the named modes.}

\item{typeof.}{character vector of types (see \code{\link{typeof}}). Selects objects with one of the named types.}

\item{filter.}{logical expression indicating elements (rows) to keep: missing values are taken as false.
Note that the expression will be evaluated in the data frame with object attributes, so
columns should be referred to (by name) as variables in the expression (see the examples).
This argument is crafted after the \code{select} argument of the base \code{subset} function.}

\item{order.}{expression involving (unquoted) attributes names, controlling the sort order
of the object entries (printed as rows) in the summary.
For example, \code{order=object.size} means sort the objects on the increasing values of
the \code{object.size} component of the summary.
\code{order=c(data.class, -object.size)} means sort the objects alphabetically by \code{data.class},
and then the decreasing values of the \code{object.size}.
If \code{order} is omitted, the entries are sorted alphabetically by object name.
This argument is crafted after the arguments to the base \code{order} function.


The attribute names to be used in \code{filter} and \code{order} expressions must be
fully specified (no partial matching possible).}

\item{reverse}{logical flag: if \code{TRUE}, the final sort order is reversed, even if
this order depends on object names (this is different from the original S-PLUS function). Default: \code{FALSE}}
}
\value{
An object of (S3) class \code{"objects.summary"}, which inherits from class \code{"data.frame"}.
Its components (printed as columns) are those specified in argument \code{what}. Each component
contains one type of information for all selected objects. They are at most the following:
 \item{\code{data.class}}{a factor (if \code{all.classes=FALSE)}, or a list of character
 vectors (if \code{all.classes=TRUE)} containing the data class information. This is defined
 as in the function \code{\link{data.class}}, with the exception that when \code{all.classes=TRUE}, the summary
 will contain the entire class attribute for each object which has one, whereas function \code{data.class}
 returns only the first element of this vector.}
 \item{\code{storage.mode}}{a factor giving the storage mode information, as returned by function \code{\link{storage.mode}}.}
 \item{\code{mode}}{a factor giving the mode information, as returned by function \code{\link{mode}}.}
 \item{\code{typeof}}{a factor giving the R internal type or storage mode information, as returned by function \code{\link{typeof}}.}
 \item{\code{extent}}{a list, each of whose components is a numeric vector giving the dimension of an object, or its length if it is dimensionless.}
 \item{\code{object.size}}{a numeric vector giving the object sizes in bytes, as returned by function \code{\link{object.size}}.}

The purpose of the dedicated class \code{objects.summary} is only to provide customized
\code{print} and \code{summary} methods.
}
\description{
Returns data class, storage mode, mode, typeof, dimensions, and size information for R objects from the
specified environment.  When invoked with no argument at the top-level prompt,
\code{objects.summary} shows what data sets and functions a user has defined in the current session.
When invoked with no argument inside a function, \code{objects.summary} returns the information
for the function's local variables: this can be useful in conjunction with \code{\link{browser}}.
}
\details{
The \code{where} argument can specify the environment from which object names
are taken in one of several forms: as an integer (the position in the
\code{\link{search}} list); as the character string name of an element in
the search list; or as an explicit \code{\link{environment}} (including
using \code{\link{sys.frame}} to access the currently active function
calls). By default, the environment of the call to \code{objects.summary}
is used.

Unless an explicit environment is provided, the \code{where} argument should
designate an element of the search list. However, if it is a character of the form
"package:pkg_name" and if the package named "pkg_name" is installed, it is silently
loaded, its objects retrieved, and then it is unloaded when the function exits.
Depending on the time it takes to load the package, the execution might be slower than
getting the information about an attached package.

It is possible to use the attributes that are not returned (not listed in \code{what})
in the \code{filter} and \code{order} expressions.
}
\examples{
.Ob <- 1
a <- letters[1:5]
x <- rnorm(20)
i <- 1:10
l <- list(a = a, i = i, x = x)
df <- iris
arr <- iris3
myfunc <- function() {ls()}
objects.summary()
objects.summary(pattern = "O")
objects.summary(pattern = "O", all.objects = TRUE)

objects.summary(mode = "function")
objects.summary("package:grDevices", filter = mode != "function")
objects.summary("package:datasets", all.classes = TRUE,
    filter = sapply(data.class, length) > 1)
# shows an empty list because inside myfunc no variables are defined
myfunc <- function() {objects.summary()}
myfunc()

# define a local variable inside myfunc
myfunc <- function() {y <- 1; objects.summary()}
myfunc()                # shows "y"

}
\references{
TIBCO Spotfire S+® 8.2 Function Guide, November 2010, TIBCO Software Inc.
}
\seealso{
\code{\link{glob2rx}} for converting wildcard patterns to regular
expressions;
\code{\link{ls.str}} for a long listing based on \code{\link{str}};
\code{\link{apropos}} (or \code{\link{find}}) for finding objects in the
whole search path; \code{\link{grep}} for more details on \sQuote{regular
expressions}; \code{\link{subset}} for filtering; \code{\link{order}} for sorting;
\code{\link{class}}, \code{\link{data.class}}, \code{\link{methods}}, etc., for
object-oriented programming.
}
\keyword{environment}
\keyword{misc}
\keyword{utilities}
