% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{openstreetmap_fr_zones}
\alias{openstreetmap_fr_zones}
\title{An sf object of geographical zones taken from download.openstreetmap.fr}
\format{
An \code{sf} object with 1187 rows and
7 columns:
\describe{
\item{id}{A unique ID for each area. It is used by \code{oe_update()}.}
\item{name}{The, usually English, long-form name of the city.}
\item{parent}{The identifier of the next larger excerpts that contains
this one, if present.}
\item{level}{An integer code between 1 and 4. Check
\url{http://download.openstreetmap.fr/polygons/} to understand the hierarchical
structure of the zones. 1L correspond to the biggest areas. This is used
only for matching operations in case of spatial input.}
\item{pbf}{Link to the latest \code{.osm.pbf} file for this region.}
\item{pbf_file_size}{Size of the pbf file in bytes.}
\item{geometry}{The \code{sfg} for that geographical region, rectangular. See
also \code{oe_get_boundary()} to extract the proper geographical boundaries.}
}
}
\source{
\url{http://download.openstreetmap.fr/}
}
\usage{
openstreetmap_fr_zones
}
\description{
An \code{sf} object containing the URLs, names, and file-sizes of the OSM
extracts stored at \url{http://download.openstreetmap.fr/}.
}
\seealso{
Other provider's-database: 
\code{\link{bbbike_zones}},
\code{\link{geofabrik_zones}}
}
\concept{provider's-database}
\keyword{datasets}
