% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{bbox_to_bng}
\alias{bbox_to_bng}
\alias{bbox_to_bng.numeric}
\alias{bbox_to_bng.matrix}
\alias{bbox_to_bng.data.frame}
\alias{bng_to_bbox}
\alias{bng_to_grid_geom}
\title{Convert bounding boxes}
\usage{
bbox_to_bng(...)

\method{bbox_to_bng}{numeric}(xmin, ymin, xmax, ymax, resolution, ...)

\method{bbox_to_bng}{matrix}(x, resolution, ...)

\method{bbox_to_bng}{data.frame}(x, resolution, ...)

bng_to_bbox(bng_ref, ...)

bng_to_grid_geom(bng_ref, format = c("geos", "sf", "wkt"), ...)
}
\arguments{
\item{...}{additional parameters, not currently used}

\item{xmin, ymin, xmax, ymax}{numeric vector of bounding box coordinates}

\item{resolution}{the resolution of the BNG reference expressed either as a
metre-based integer or as a string label}

\item{x}{optional input of the bounding box as a matrix or data frame of
values. Either a numeric vector or object must be supplied.}

\item{bng_ref}{vector of type \code{BNGReference} objects}

\item{format}{character indicating the type of geometry object to return.
Default is "geos" while "sf" returns an object of class \code{sfc}.}
}
\value{
\itemize{
\item \code{bng_to_bbox}: numeric vector of bounding easting and northing
coordinates. If multiple references are supplied to \code{bng_ref} then a
matrix of coordinates is returned.
\item \code{bbox_to_bng}: list containing vectors of \code{BNGReference}
objects.
\item \code{bng_to_grid_geom} converts the bounding box coordinates into a
polygon geometry object.
}
}
\description{
Create British National Grid reference from bounding boxes or convert grid
reference objects into bounding boxes.
}
\details{
The relationship between the bounding box and the returned BNG grid squares
depends on the alignment of the bounding box with the BNG index system:

If the bounding box edges align with the BNG system (e.g. xmin, ymin, xmax,
ymax are multiples of the specified resolution), only the grid squares
entirely contained within the bounding box are returned. Grid squares that
intersect but are not fully contained within the bounding box are excluded.

If the bounding box edges are not aligned with the BNG system, grid squares
that are partially overlapped by the bounding box are also included. In this
case, the function ensures all relevant grid squares that the bounding box
touches are returned, including those at the edges.

Validates and normalises the bounding box coordinates to the BNG index system
extent. If bounding box coordinates fall outside of the BNG system extent,
the coordinates are snapped to the bounds of the BNG system.

Bounding boxes are expressed as four coordinates (min x, min y, max x, max
y). Coordinates must be in British National Grid projection (EPSG:27700).
These functions do not support coordinate transformations.

For matrix input, the first four columns are used as xmin, ymin, xmax, and
ymax, respectively. For \code{data.frame} input columns must be named "xmin",
"ymin", "xmax", and "ymax" or the first columns will be assumed.

To return the BNG grid squares within the bounding box of a geometry, see
\code{geom_to_bng()}.
}
\examples{
bbox_to_bng(400000, 100000, 500000, 200000, "50km")

bbox_to_bng(285137.06, 78633.75, 299851.01, 86427.96, 5000)

bng_to_bbox(as_bng_reference("SU"))

bng_to_bbox(as_bng_reference("SU 3 1"))

bng_to_bbox(as_bng_reference("SU 3 1 NE"))

bng_to_bbox(as_bng_reference("SU 37289 15541"))

bng_to_grid_geom(as_bng_reference("SU"))

bng_to_grid_geom(as_bng_reference("SU 3 1"))

bng_to_grid_geom(as_bng_reference("SU 3 1 NE"))

bng_to_grid_geom(as_bng_reference("SU 37289 15541"))

}
