library(orthGS)


## ---------------------------------------------- ##
#             Testing msa                          #
## ---------------------------------------------- ##
test_that("msa() works properly", {

  skip_on_cran()
  skip_on_travis()

  sequences <- c("MQPIPDVNQRIARISAHLHPPKSQMEESSALRRANCRAKGGAPGFKV",
                 "MSEPIRVLVTGAAGQIAYSLLYSIGNGSVFGKDQPIILVLLDITPMM",
                 "MSEPIRVLVTGAAGQIAYSLLYSIGNGSVFGKDQPIILVLLDITPMM")
  names(sequences) <- c("P19446", "P40925", "P40926")

  b <- msa(sequences = sequences, ids = c("wmelon", "cyt", "mit"), method = "muscle")
  c <- msa(sequences = sequences, ids = c("wmelon", "cyt", "mit"), method = "clustalo")

  # a <- msa(sequences = sequences, ids = c("wmelon", "cyt", "mit"), inhouse = FALSE) # using muscle R pkg
  # b <- msa(sequences = sequences,
  #          ids = c("wmelon", "cyt", "mit"), inhouse = TRUE)

  # expect_is(a, "list")
  # expect_equal(length(a), 4)
  # expect_is(a[[1]], 'character')
  # expect_equal(length(a[[1]]), 3)
  # expect_equal(names(a[[1]]), c("P19446", "P40925", "P40926"))
  # expect_equivalent(nchar(a[[1]][1]), 47)
  # expect_is(a[[2]], 'character')
  # expect_equal(length(a[[2]]), 3)
  # expect_equal(a[[2]], c("wmelon", "cyt", "mit" ))
  # expect_equal(length(a[[3]]), 3)
  # expect_equivalent(nchar(a[[3]][1]), 57)
  # expect_is(a[[4]], 'matrix')
  # expect_equal(dim(a[[4]]), c(3, 57))

  expect_is(b, "fasta")
  expect_equal(length(b), 4)
  expect_is(b[[1]], 'character')
  expect_equal(length(b[[1]]), 3)
  expect_equal(dim(b$ali), c(3,57))
  expect_equal(b$id, c("wmelon", "cyt", "mit" ))
  expect_is(b[[2]], "matrix")
  expect_is(b[[4]], 'character')

  expect_is(c, "fasta")
  expect_equal(length(c), 4)
  expect_is(c[[1]], 'character')
  expect_equal(length(c[[1]]), 3)
  expect_equal(dim(c$ali), c(3,74))
  expect_equal(c$id, c("wmelon", "cyt", "mit" ))
  expect_is(c[[2]], "matrix")
  expect_is(c[[4]], 'character')
})
## ----------------------------------------------- ##
#          Testing the function mltree              #
## ----------------------------------------------- ##
test_that("mltree() works properly", {

  skip_on_cran()
  skip_on_travis()

  # a <- mltree(msa = gapless_msa(msa = "./data_t/rbl.txt", df = FALSE))
  a <- mltree(msa = "./data_t/rbl.txt", df = FALSE)

  expect_is(a, 'pml')
  expect_true(is.list(a))
  expect_equal(length(a), 25)
  expect_is(a$tree, 'phylo')
  expect_true("Abies_pinsapo" %in% a$tree$tip.label)

})

## ----------------------------------------------- ##
#     Testing the function gapless_msa              #
## ----------------------------------------------- ##
test_that("gapless_msa() works properly", {

  skip_on_cran()
  skip_on_travis()

  a <- gapless_msa(msa = "./data_t/rbl.txt", seqtype = "AA", df = FALSE)

  expect_is(a, 'data.frame')
  expect_equal(dim(a) , c(22, 236))
})


## ----------------------------------------------- ##
#          Testing the function madRoot             #
## ----------------------------------------------- ##
PpGS1b1 <- "MSLLTDLINLDLSDVTEKIIAEYIWIGGSGMDIRSKARTLSHPVTDPKDLPKWNYDGSSTGQAPGKDSEVILYPQAIFRDPFRRGNNILVICDTYTPAGEPIPTNKRANAAKIFSHPDVVVEEPWYGIEQEYTLLQKDVNWPLGWPVGGYPGPQGPYYCGTGADKAYGRDIVDAHYKACLYAGINISGINGEVMPGQWEFQVGPTVGISSGDQVWAARYLLERITEVAGVVLSFDPKPIQGDWNGAGAHTNYSTKSMREEGGIKVIKKAIEKLGLRHKEHIAAYGEGNERRLTGRHETADINTFSWGVANRGASIRVGRDTEREGKGYFEDRRPASNMDPYIVTSMIAETTILLK"
PpGS1b2 <- "MSLLTDLINLDLSDVTEKIIAEYIWIGGSGMDIRSKGRTLSHEVTDPKDLPKWNYDGSSTGQAPGKDSEVIIHPQAIFRDPFRRGKNILVICDAYTPAGEPIPTNKRANAANIFSHPDVVAEEPWFGIEQEYTLLQKDLNWPLGWPIGGFPGPQGPYYCGTGADKAYGRDIVDAHYKACLYAGINISGINGEVMPGQWEFQVGPTVGISSGDQVWAARYILERISEMAGVVVSFDPKPIQGDWNGAGAHTNYSTKSMREEGGIEVIHKAIEKLALRHKEHIAAYGEGNERRLTGQHETADINTFSWGVANRGASVRIGRDTERLGKGYFEDRRPSSNMDPYVVTSLIAETTILLKPE"
PpGS1a <- "MSSVLTDLLNLDLSDVTEKVIAEYIWIGGSGMDMRSKARSLSGPVSSVKELPKWNYDGSSTGQAQGHDSEVILYPQAIFRDPFRRGKHILVICDAYSPNGTAIPSNKRAAAAKIFNEKAVIDEETWYGLEQEYTLLQKDVKWPLGWPIGGYPGPQGPYYCGVGADKAWGRDMVDAHYKACLYSGINISGINGEVMPGQWEFQVGPSVGISAADELWCARFIMERITEKAGVVLSFDPKPIEGDWNGAGCHTNYSTKSMRKEGGFEVIKKAIEKLKLRHKEHISAYGEGNERRLTGRHETADMNSFSWGVANRGASVRVGRDTEKEGKGYFEDRRPASNMDPYIVTSMIAETTILWKP"
AbiGS1b <- "MSLLTDLINLNLSDVTDKIIAEYIWIGGSGMDIRSKARTLSHEVTDPKHLPKWNYDGSSTGQAPGKDSEVILYPQAIFRDPFRRGKNILVMCDAYTPAGEPIPTNKRANAAKIFSHPDVAAEEPWFGIEQEYTLLQKDVKWPLGWPIGGFPGPQGPYYCGTGADKAYGRDIVDAHYKACLYAGINISGINGEVMPGQWEFQVGPTVGISSGDQVWAARYLLERITEMAGVVLSFDPKPIQGDWNGAGAHTNYSTKSMRKEGGIAVIKKAIEKLGLRHKQHIAAYGEGNERRLTGRHETADINTFSWGVANRGASIRVGRDTEQEGKGYFEDRRPASNMDPYIVTSMIAETTLLLK"
AbiGS1a <- "MSSVLTDLLNLDLSDVTEKVIAEYIWIGGSGLDMRSKAKSLSGPVSSPKELPKWNYDGSSTGQAQGHDSEVILYPQAIYPDPFRRGKHVLVICDTYSPNGTAISSNKRAAAEKIFNTKEVIDEETWYGLEQEYTLLQKDVKWPLGWPIGGFPGPQGPYYCGVGADKAWGRDIVDAHYKACLYAGINVSGTNGEVMPGQWEFQVGPSVGISAADELWCARYIMERITEHAGVVLSFDPKPIEGDWNGAGCHTNYSTKSMRKEGGFEVIKKAIEKLRLRHKEHIAAYGEGNERRLTGRHETADIHTFSWGVANRGASVRVGRDTEKDGKGYFEDRRPASNMDPYTVTSMIAETTVLWKP"
AtrGS1a <- "MSILTDLLNLDLTDCTTKIIAEYIWVGGSGMDLRSKARTISSPVNSPKQLPKWNYDGSSTGQAAGHDSEVILYPQAIFPDPFRRGKNILVICDTYAPDGTPIATNKRAAAEKIFSNPQVVAEEPWYGLEQEYTLLQKDVKWPLGWPIGGFPGPQGPYYCGIGADKAWGRDVVDSHYKACLYAGINISGINGEVMPGQWEFQVGPSEGISAGDELWCARYILERITEIAGVVLTFDPKPIQGDWNGAGCHTNYSTKSTRKEGGYEVIKKAIEKLGLRHKEHIAAYGEGNERRLTGHHETADINTFSWGVANRGASVRVGRDTEKEGRGYFEDRRPASNMDPYVVTSMIAETTILWNS"
AtrGS1b1 <- "MALLQDLISLNLSDSTEKIIAEYIWIGGSGLDMRSKARTLSGPVSDSRKLPKWNYDGSSTGQAPGDDSEVILYPQAVFKDPFRRGNNILVMCDAYTPGGGPIPTNKRFNAAKIFSHPDVAAEVPWYGIEQEYTLLRKDVNWPLGWPVGGFPGPQGPYYCGVGADKAFGRDIVDAHYKACLYAGINISGINGEVMPGQWEFQVGPAVGISAGDEIWVARYILERITEIAGVVVSFDPKPIPGDWNGAGAHTNYSTKSMREDGGIDVIKKAIEKLGLRHKEHISAYGEGNERRLTGHHETADINTFSWGVANRGASVRVGRDTEKDGKGYFEDRRPASNMDPYVVTSMIAETTILWKP"
AtrGS1b2 <- "MSLLTDLINLNLSDSTEKVIAEYIWIGGSGMDLRSKGRTLSGPENDPSKLPKWNYDGSSTGQAPGEDSEVILYPQAIFPDPFRRGKNILVMCDAYTPAGEPIPTNKRYNAAKIFSHPDVVAEEPWYGIEQEYTLLQKDTNWPIGWPIGGFPGPQGPYYCGIGADKAFGRDIVNAHYKACLYAGINMSGINGEVMPGQWEFQVGPSVGISSGDQIWVARYILERIAEIAGVVVSFDPKPIPGDWNGAGCHSNYSTKSMRSDGGFDVIKKAIEKLGLRHKEHIAAYGEGNERRLTGRHETADINTFSWGVANRGASIRVGRETEREGKGYFEDRRPASNMDPYVVTSKIAETTVLWKP"
AtrGS2 <- "MAQILAPSMQCQMGSAKISIKAGPVTAKMWNSLVLNHRLSGRNSFKSASKFRAFSVKAASDNGVVNRLEDLLKLDLTPITDKIIAEYIWIGGSGTDLRSKSRTISRPVESALGLPKWNYDGSSTGQAPGEDSEVILYPQAIFKDPFRGGNNILVICDAYTPAGEPLPTNKRYRAAQIFSEKKVIDEVPWYGIEQEYTLLQPNVKWPLGWPVGGYPGPQGPYYCGTGADKAFGRDISDAHYKACLYAGINISGTNGEVMPGQWEYQVGPSVGIDAGDHVWCSRYLLERITEMAGVVLSLDPKPIEGDWNGAGCHTNFSTKSMRDEGGYAVIKKAIRNLSLRHKEHIGAYGEGNERRLTGKHETASIDTFSWGVANRGCSIRVGRETEKQGKGYLEDRRPASNMDPYVVTSLLAETAILFEPTLEVESLAAKKLQ"
OsaGS1b1 <- "MASLTDLVNLNLSDTTEKIIAEYIWIGGSGMDLRSKARTLSGPVTDPSKLPKWNYDGSSTGQAPGEDSEVILYPQAIFKDPFRKGNNILVMCDCYTPAGEPIPTNKRHNAAKIFSSPEVASEEPWYGIEQEYTLLQKDINWPLGWPVGGFPGPQGPYYCGIGADKSFGRDIVDSHYKACLYAGINISGINGEVMPGQWEFQVGPSVGISAGDQVWVARYILERITEIAGVVVSFDPKPIPGDWNGAGAHTNYSTKSMRNDGGYEIIKSAIEKLKLRHKEHISAYGEGNERRLTGRHETADINTFSWGVANRGASVRVGRETEQNGKGYFEDRRPASNMDPYIVTSMIAETTIIWKP"
OsaGS1b2 <- "MANLTDLVNLNLSDCSDKIIAEYIWVGGSGIDLRSKARTVKGPITDVSQLPKWNYDGSSTGQAPGEDSEVILYPQAIFKDPFRRGDNILVMCDCYTPQGEPIPTNKRHSAAKIFSHPDVVAEVPWYGIEQEYTLLQKDVNWPLGWPVGGFPGPQGPYYCAAGAEKAFGRDIVDAHYKACIYAGINISGINGEVMPGQWEFQVGPSVGIAAADQVWVARYILERVTEVAGVVLSLDPKPIPGDWNGAGAHTNFSTKSMREPGGYEVIKKAIDKLALRHKEHIAAYGEGNERRLTGRHETADINTFKWGVANRGASIRVGRDTEKEGKGYFEDRRPASNMDPYVVTGMIAETTLLWKQN"
OsaGS1b3 <- "MSSSLLTDLVNLDLSESTDKVIAEYIWVGGTGMDVRSKARTLSGPVDDPSKLPKWNFDGSSTGQATGDDSEVILHPQAIFRDPFRKGKNILVMCDCYAPNGEPIPTNNRYNAARIFSHPDVKAEEPWYGIEQEYTLLQKHINWPLGWPLGGYPGPQGPYYCAAGADKSYGRDIVDAHYKACLFAGINISGINAEVMPGQWEFQIGPVVGVSAGDHVWVARYILERITEIAGVVVSFDPKPIPGDWNGAGAHTNYSTKSMRSNGGYEVIKKAIKKLGMRHREHIAAYGDGNERRLTGRHETADINNFVWGVANRGASVRVGRDTEKDGKGYFEDRRPASNMDPYLVTAMIAETTILWEPSHGHGHGQSNGK"
OsaGS2 <- "MAQAVVPAMQCQVGAVRARPAAAAAAAGGRVWGVRRTGRGTSGFRVMAVSTETTGVVTRMEQLLNMDTTPFTDKIIAEYIWVGGTGIDLRSKSRTISKPVEDPSELPKWNYDGSSTGQAPGEDSEVILYPQAIFKDPFRGGNNILVMCDTYTPAGEPIPTNKRNRAAQVFSDPKVVSQVPWFGIEQEYTLLQRDVNWPLGWPVGGYPGPQGPYYCAVGSDKSFGRDISDAHYKACLYAGINISGTNGEVMPGQWEYQVGPSVGIEAGDHIWISRYILERITEQAGVVLTLDPKPIQGDWNGAGCHTNYSTKSMREDGGFEVIKKAILNLSLRHDLHISAYGEGNERRLTGLHETASIDNFSWGVANRGCSIRVGRDTEAKGKGYLEDRRPASNMDPYVVTALLAETTILWEPTLEAEVLAAKKLALKV"

test_that("madRoot() works properly", {

  skip_on_cran()
  skip_on_travis()

  a <- msa(sequences = c(PpGS1b1, PpGS1b2, PpGS1a, AbiGS1b, AbiGS1a, AtrGS1a, AtrGS1b1, AtrGS1b2, AtrGS2, OsaGS1b1, OsaGS1b2, OsaGS1b3, OsaGS2),
                     ids = c("PpGS1b1", "PpGS1b2", "PpGS1a", "AbiGS1b", "AbiGS1a", "AtrGS1a", "AtrGS1b1", "AtrGS1b2", "AtrGS2", "OsaGS1b1", "OsaGS1b2", "OsaGS1b3","OsaGS2"))$ali
  rownames(a) <- c("PpGS1b1", "PpGS1b2", "PpGS1a", "AbiGS1b", "AbiGS1a", "AtrGS1a", "AtrGS1b1", "AtrGS1b2", "AtrGS2", "OsaGS1b1", "OsaGS1b2", "OsaGS1b3","OsaGS2")
  utr <- mltree(a)$tree
  phy <- madRoot(tree = utr, output_mode = "phylo")
  sta <- madRoot(tree = utr, output_mode = "stats")
  ful <- madRoot(tree = utr, output_mode = "full")

  expect_is(phy, 'phylo')
  expect_true(is.list(phy))
  expect_equal(length(phy), 4)

  expect_is(sta, 'list')
  expect_equal(length(sta), 2)
  expect_is(sta[[1]], 'phylo')
  expect_equal(as.numeric(sta[[2]][1]), 0.79, tolerance=1e-3)
  expect_true(is.list(phy))
  expect_equal(phy, sta[[1]])

  expect_is(ful, 'list')
  expect_is(ful[[1]], 'character')
  expect_is(ful[[2]], 'data.frame')
  expect_is(ful[[3]], 'phylo')
  expect_is(ful[[4]], 'integer')
  expect_is(ful[[5]], 'numeric')
  expect_is(ful[[6]], 'phylo')
  expect_equal(sta[[2]], ful[[2]])
  expect_equal(length(ful[[5]]), 23)
  expect_equal(ful[[6]], phy)

})

