% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orth.R
\name{orthology}
\alias{orthology}
\title{Infer OrthoGroups Using Tree Reconciliation}
\usage{
orthology(trees, invoke, d = 2, t = 10, l = 1, plot = TRUE, saverec = FALSE)
}
\arguments{
\item{trees}{path to a single file containing first the species tree, followed by a  single gene/protein tree (see details).}

\item{invoke}{character string representing the way in which the executable of RANGER-DTL (see details) is invoked.}

\item{d}{cost assigned to gene duplication.}

\item{t}{cost assigned to gene transfer.}

\item{l}{cost assigned to gene loss.}

\item{plot}{when TRUE, the orthology network graph is plotted.}

\item{saverec}{path to the directory where to save the reconciliation file. If not provided the file is not saved (default)}
}
\value{
A list with four elements. The first one is a 'phylo' object where the nodelabels indicate the event: D, duplication or T transfer. If no label is shown is because the event correspond to speciation. The second element is a dataframe (the first column is the label of the internal nodes in the gene tree; the second column is the label of the internal nodes in the species tree, and the third and fourth columns label each internal node according to the inferred event). The third element of the list is an adjacency matrix: 1 when two proteins are orthologous, 0 if they are paralogous. The last element of the list is an orthogroup graph.
}
\description{
Infer orthogroups using species and gene trees reconciliation
}
\details{
The executable of RANGER-DTL (https://compbio.engr.uconn.edu/software/RANGER-DTL) should be installed. All input trees must be expressed using the Newick format terminated by a semicolon, and they must be fully binary (fully resolved) and rooted. Species names in the species tree must be unique. E.g, E.g., (((speciesA_gene1, speciesC_gene1), speciesB_geneX), speciesC_gene2); and (((speciesA, speciesC), speciesB), speciesC); are both valid gene tree inputs and, in fact, represent the same gene tree. This gene tree contains one copy of the gene from speciesA and speciesB, and two copies from speciesC.
}
\examples{
\donttest{orthology(trees = system.file("extdata", "input.trees", package = "orthGS"))}
}
