% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPPplus_fourier_v3.r
\name{rpp_fft}
\alias{rpp_fft}
\title{SPP Analysis via fourier}
\usage{
rpp_fft(time_wave, resp_wave, L, omega, M, p)
}
\arguments{
\item{time_wave}{Lx1 vector of time at each measurement point}

\item{resp_wave}{Lx3 matrix of the strain, rate and stress data,with each row representing a measuring point}

\item{L}{number of measurement points in the extracted data}

\item{omega}{frequency of oscilation (rad/s)}

\item{M}{number of harmonics for stress}

\item{p}{number of cycles}
}
\value{
a list with the following data frame
        spp_data_in= the data frame with the data
			 spp_params=spp_params, 
			 spp_data_out= Length,frequency,harmonics,cycles,max_harmonics,step_size
			 fsf_data_out= Tx,Ty,Tz,Nx,Ny,Nz,Bx,By,Bz coordinates of the trajectory (T=tangent,N=principal Normal,B=Binormal Vectors)
			 ft_out=data frame with that includes time_wave,strain,rate,stress,Gp_t,Gpp_t,G_star_t,tan_delta_t,delta_t,disp_stress,eq_strain_est,Gp_t_dot,Gpp_t_dot,G_speed,delta_t_dot)
}
\description{
applies the SPP Analysis by means of a fourier series.
}
\examples{
data(mydata)
df <- rpp_read2(mydata , selected=c(2, 3, 4, 0, 0, 1, 0, 0))
time_wave <- df$raw_time
resp_wave <- data.frame(df$strain,df$strain_rate,df$stress) 
out <- rpp_fft(time_wave,resp_wave,L=1024,omega=3.16 , M=15,p=1)
}
\references{
Simon A. Rogersa, M. Paul Letting, A sequence of physical processes determined and quantified in large-amplitude oscillatory shear (LAOS): Application to theoretical nonlinear models
Journal of Rheology 56:1, 1-25
}
\author{
Simon Rogers Group for Soft Matter (matlab version), Giorgio Luciano and Serena Berretta (R version)
}
\keyword{SPP}
\keyword{fourier}
