% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rpp_ggplot_v3.r, R/Rpp_plot_v3.r
\name{plotStressStrain}
\alias{plotStressStrain}
\title{Stress-Strain plot}
\usage{
plotStressStrain(stress, strain, strain_in, stress_in, ...)

plotStressStrain(stress, strain, strain_in, stress_in, ...)
}
\arguments{
\item{stress}{data the output matrix from fft analysis or numerical differentiation analysis}

\item{strain}{data the output matrix from fft analysis or numerical differentiation analysis}

\item{strain_in}{data the input matrix from fft analysis or numerical differentiation analysis}

\item{stress_in}{data the input matrix from fft analysis or numerical differentiation analysis}

\item{...}{parameters of plot()}
}
\value{
{No return value}

{No return value}
}
\description{
create Stress Strain Plot

create Stress Strain Plot
}
\examples{
\donttest{ data(mydata)
df <- rpp_read2(mydata , selected=c(2, 3, 4, 0, 0, 1, 0, 0))
time_wave <- df$raw_time
resp_wave <- data.frame(df$strain,df$strain_rate,df$stress) 
out <- Rpp_num(time_wave, resp_wave , L=1024, k=8, num_mode=1)
strain= out$spp_data_out$strain
stress= out$spp_data_out$stress
strain_in= out$spp_data_in$strain
stress_in= out$spp_data_in$stress
plotStressStrain(stress, strain,strain_in,stress_in)}

}
\references{
Simon A. Rogersa, M. Paul Letting, A sequence of physical processes determined and quantified in large-amplitude oscillatory shear (LAOS): Application to theoretical nonlinear models
Journal of Rheology 56:1, 1-25

Simon A. Rogersa, M. Paul Letting, A sequence of physical processes determined and quantified in large-amplitude oscillatory shear (LAOS): Application to theoretical nonlinear models
Journal of Rheology 56:1, 1-25
}
\author{
Giorgio Luciano and Serena Beretta, based on the Plotting functions created by Simon Rogers Group for Soft Matter

Giorgio Luciano and Serena Beretta, based on the Plotting functions created by Simon Rogers Group for Soft Matter
}
\keyword{SPP}
\keyword{Stress-Strain}
\keyword{plot}
