% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-origin.r
\name{geom_origin}
\alias{geom_origin}
\alias{geom_unit_circle}
\title{Marker or unit circle at the origin}
\usage{
geom_origin(
  mapping = NULL,
  data = NULL,
  marker = "crosshairs",
  radius = unit(0.04, "snpc"),
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE
)

geom_unit_circle(
  mapping = NULL,
  data = NULL,
  segments = 60,
  scale.factor = 1,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{marker}{The symbol to be drawn at the origin; matched to \code{"crosshairs"}
or \code{"circle"}.}

\item{radius}{A \code{\link[grid:unit]{grid::unit()}} object that sets the radius of the crosshairs
or of the circle.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{na.rm}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{segments}{The number of segments to be used in drawing the circle.}

\item{scale.factor}{The circle radius; should remain at its default value 1
or passed the same value as \code{\link[=ggbiplot]{ggbiplot()}}. (This is an imperfect fix that
may be changed in a future version.)}
}
\value{
A ggproto \link[ggplot2:layer]{layer}.
}
\description{
\code{geom_origin()} renders a symbol, either a set of crosshairs or
a circle, at the origin. \code{geom_unit_circle()} renders the unit circle,
centered at the origin with radius 1.
}
\section{Biplot layers}{

\code{\link[=ggbiplot]{ggbiplot()}} uses \code{\link[ggplot2:fortify]{ggplot2::fortify()}} internally to produce a single data
frame with a \code{.matrix} column distinguishing the subjects (\code{"rows"}) and
variables (\code{"cols"}). The stat layers \code{stat_rows()} and \code{stat_cols()} simply
filter the data frame to one of these two.

The geom layers \verb{geom_rows_*()} and \verb{geom_cols_*()} call the corresponding
stat in order to render plot elements for the corresponding factor matrix.
\verb{geom_dims_*()} selects a default matrix based on common practice, e.g.
points for rows and arrows for columns.
}

\section{Aesthetics}{

\code{geom_origin()} accepts no aesthetics.
\code{geom_unit_circle()} understands the following aesthetics (none required):
\itemize{
\item \code{linetype}
\item \code{linewidth}
\item \code{colour}
\item \code{alpha}
}
}

\examples{
ggplot(seals, aes(delta_long, delta_lat)) +
  theme_void() +
  geom_origin() +
  geom_point(alpha = .25)
# center each group separately
iris \%>\%
  split(~ Species) \%>\%
  lapply(subset, select = -c(Species)) \%>\%
  lapply(scale, center = TRUE, scale = FALSE) \%>\%
  lapply(as.data.frame) \%>\%
  unsplit(iris$Species) \%>\%
  transform(Species = iris$Species) ->
  iris_ctr
ggplot(iris_ctr, aes(Petal.Width, Petal.Length)) +
  coord_equal() +
  facet_wrap(vars(Species)) +
  geom_unit_circle() +
  geom_point()
# scale group mean differences uniformly
iris_ctr \%>\%
  subset(select = -c(Species)) \%>\%
  scale(center = FALSE, scale = TRUE) \%>\%
  transform(Species = iris$Species) \%>\%
  ggplot(aes(Petal.Width, Petal.Length)) +
  coord_equal() +
  facet_wrap(vars(Species)) +
  geom_unit_circle() +
  geom_point()

}
\seealso{
Other geom layers: 
\code{\link{geom_interpolation}()}
}
\concept{geom layers}
