% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_association.R
\name{Goodman_uniform_association}
\alias{Goodman_uniform_association}
\title{Fits Goodman's (1979) uniform association model}
\usage{
Goodman_uniform_association(
  n,
  max_iter = 25,
  verbose = FALSE,
  exclude_diagonal = FALSE
)
}
\arguments{
\item{n}{matrix of observed counts}

\item{max_iter}{maximum number of iterations. Default is 10.}

\item{verbose}{should cycle-by-cycle info be printed out? Default is FALSE}

\item{exclude_diagonal}{logical. Should the cells of the main diagonal be
excluded from the computations? Default is FALSE, include all cells.}
}
\value{
a list containing
   alpha: row effects
   beta: column effects
   theta: uniform association parameter
   log_likelihood: log(likelihood)
   g_squared: G^2 fit measure
   chisq: X^2 fit measure
   df: degrees of freedom
}
\description{
Fits Goodman's (1979) uniform association model
}
