% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Agresti_marginal_homogeneity.R
\name{Agresti_w_diff}
\alias{Agresti_w_diff}
\title{Computes the weighted statistics listed in section 2.3.}
\usage{
Agresti_w_diff(w, n)
}
\arguments{
\item{w}{a vector of weights to be treated as scores}

\item{n}{matrix of observed counts}
}
\value{
a list containing
   diff: the weighted contrast computed using weights w
   sigma_diff: SE(diff)
   z_diff: z-score for diff
}
\description{
Computes weighted contrast of the two margins.
Agresti, A. (1983). Testing marginal homogeneity for ordinal categorical variables.
Biometrics, 39(2), 505-510.
}
\examples{
weights = c(-3.0, -1.0, 1.0, 3.0)
Agresti_w_diff(weights, vision_data)
}
