% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainCode.R
\name{simu.olbm}
\alias{simu.olbm}
\title{Simulate OLBM data}
\usage{
simu.olbm(M, P, Pi, rho, delta, mu, sd, thresh)
}
\arguments{
\item{M}{The number of rows of the ordinal matrix Y.}

\item{P}{The number of columns of the ordinal matrix Y.}

\item{Pi}{A Q x L connectivity matrix to manage missing data (coded az zeros in Y).}

\item{rho}{A vector of length Q, containing multinomial probabilities for row cluster assignments.}

\item{delta}{A vector of length L, containing multinomial probabilities for column cluster assignments.}

\item{mu}{A Q x L matrix containing the means of the latent Gaussian distributions.}

\item{sd}{A Q x L matrix containing the standard deviations of the latent Gaussian distributions.}

\item{thresh}{A K+1 vector containing the sorted tresholds used to simulate the ordinal entries in Y, where K is the number of ordinal modalities. The first entry in tresh must be -Inf, the last entry +Inf.}
}
\value{
It returns a list containing:  
              \item{Y}{An M x P matrix. The observed ordinal entries are integers between 1 and K. Missing data are coded as zeros.}
              \item{Rclus}{A vector of length M containing the row cluster memberships.}
              \item{Cclus}{A vector of length P containing the column cluster memberships.}
}
\description{
It simulates an ordinal data matrix according to OLBM.
}
\examples{

M <- 150                                    
P <- 100 
Q <- 3
L <- 2

## connectivity matrix
Pi <- matrix(.7, nrow = Q, ncol = L)
Pi[1,1] <- Pi[2,2] <- Pi[3,2] <- .5

## cluster memberships proportions
rho <- c(1/3, 1/3 ,1/3)
delta <- c(1/2, 1/2)

# Thresholds
thresh <- c(-Inf, 2.37, 2.67, 3.18, 4.33, Inf)     # K = 5

## Gaussian parameters
mu <- matrix(c(0, 3.4, 2.6, 0, 2.6, 3.4), nrow = Q, ncol = L)   
sd <- matrix(c(1.2,1.4,1.0,1.2,1.4,1.0), nrow = Q, ncol = L)

## Data simulation
dat <- simu.olbm(M, P, Pi, rho, delta, mu, sd, thresh)

}
\references{
Corneli M.,Bouveyron C. and Latouche P. (2019) \emph{Co-Clustering of ordinal data via latent continuous random variables and a classification EM algorithm. }(\url{https://hal.archives-ouvertes.fr/hal-01978174})
}
