% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{callpremium}
\alias{callpremium}
\title{Call Premium}
\usage{
callpremium(s, x, sigma, t, r, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use the function r.cont}

\item{d}{Annual continuously-compounded dividend yield, use the function r.cont}
}
\value{
Returns the value of the call option
}
\description{
Calculates the premium of a European-style call option using the Black-Scholes option pricing model
}
\examples{
callpremium(100, 100, 0.20, (45/365), 0.02, 0.02)
}
