% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lpsolveapi_solver.R
\name{add_lpsolveapi_solver}
\alias{add_lpsolveapi_solver}
\title{Add a lp_solve solver with \pkg{lpSolveAPI}}
\usage{
add_lpsolveapi_solver(x, gap = 0, presolve = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{\linkS4class{ProjectProblem} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative
and expresses the acceptable deviance from the optimal objective.
For example, a value of 0.01 will result in the solver stopping when
it has found a solution within 1\% of optimality.
Additionally, a value of 0 will result in the solver stopping
when it has found an optimal solution.
The default value is 0.1 (i.e. 10\% from optimality).}

\item{presolve}{\code{logical} indicating if attempts to should be made
to simplify the optimization problem (\code{TRUE}) or not (\code{FALSE}).
Defaults to \code{TRUE}.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems?}
}
\value{
\linkS4class{ProjectProblem} object with the solver added
to it.
}
\description{
Specify that the \emph{lp_solve} software should be used to solve a
project prioritization \code{\link[=problem]{problem()}} using the \pkg{lpSolveAPI}
package. This function can also be used to customize the behavior of the
solver. It requires the \pkg{lpSolveAPI} package.
}
\details{
\href{https://lpsolve.sourceforge.net/5.5/}{\emph{lp_solve}} is an
open-source integer programming solver.
Although this solver is the slowest currently supported solver,
it is also the only exact algorithm solver that can be installed on all
operating systems without any manual installation steps. This solver is
provided so that
users can try solving small project prioritization problems, without
needing to install additional software. When solve moderate or large
project prioritization problems, consider using
\code{\link[=add_gurobi_solver]{add_gurobi_solver()}}.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with lpSolveAPI solver
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions() \%>\%
     add_lpsolveapi_solver()

# print problem
print(p)

# solve problem
s <- solve(p)

# print solution
print(s)

# plot solution
plot(p, s)
}
\seealso{
\link{solvers}.
}
