% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-RunModels.R
\name{run_model}
\alias{run_model}
\alias{get_model_run_state}
\alias{get_run_state}
\alias{stop_model_run}
\alias{stop_run}
\title{Run Models and Monitor Progress}
\usage{
run_model(data)

get_model_run_state(model, stamp)

get_run_state(model, stamp)

stop_model_run(model, stamp)

stop_run(model, stamp)
}
\arguments{
\item{data}{Data used for the body of the POST request.}

\item{model}{Model digest or name.}

\item{stamp}{Model run stamp.}
}
\value{
A \code{list} or nothing, invisibly.
}
\description{
More information about these API endpoints can be found at
\href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#run-models-run-models-and-monitor-progress}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
get_model_run_state("RiskPaths", "2025_01_28_21_00_48_385")
}

}
