% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-comics.R
\docType{data}
\name{comics}
\alias{comics}
\title{comics}
\format{
A data frame with 21821 observations on the following 11 variables.
\describe{
\item{name}{Name of the character. May include: Real name, hero or villain name,  alias(es) and/or which universe they live in (i.e. Earth-616 in Marvel's multiverse).}
\item{id}{Status of the characters identity with levels \code{Secret}, \code{Publie}, \verb{No Dual} and \code{Unknown}.}
\item{align}{Character's alignment with levels \code{Good}, \code{Bad}, \code{Neutral} and \verb{Reformed Criminals}.}
\item{eye}{Character's eye color.}
\item{hair}{Character's hair color.}
\item{gender}{Character's gender.}
\item{gsm}{Character's classification as a gender or sexual minority.}
\item{alive}{Is the character dead or alive?}
\item{appearances}{Number of comic boooks the character appears in.}
\item{first_appear}{Date of publication for the comic book the character first appeared in.}
\item{publisher}{Publisher of the comic with levels \code{Marvel} and \code{DC}.}
}
}
\usage{
comics
}
\description{
A data frame containing information about comic book characters from Marvel Comics and DC Comics.
}
\examples{

library(ggplot2)
library(dplyr)

# Good v Bad

plot_data <- comics |>
  filter(align == "Good" | align == "Bad")

ggplot(plot_data, aes(x = align, fill = align)) +
  geom_bar() +
  facet_wrap(~publisher) +
  scale_fill_manual(values = c(IMSCOL["red", "full"], IMSCOL["blue", "full"])) +
  theme_minimal() +
  labs(
    title = "Is there a balance of power",
    x = "",
    y = "Number of characters",
    fill = ""
  )
}
\keyword{datasets}
