% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-ami_occurrences.R
\docType{data}
\name{ami_occurrences}
\alias{ami_occurrences}
\title{Acute Myocardial Infarction (Heart Attack) Events}
\format{
A data frame with 365 observations on the following variable.
\describe{
\item{ami}{Number of daily occurrences of heart attacks in NY City.}
}
}
\usage{
ami_occurrences
}
\description{
This dataset is simulated but contains realistic occurrences of AMI in NY
City.
}
\examples{

library(ggplot2)

ggplot(ami_occurrences, mapping = aes(x = ami)) +
  geom_bar() +
  labs(
    x = "Acute Myocardial Infarction events",
    y = "Count",
    title = "Acute Myocardial Infarction events in NYC"
  )
}
\keyword{datasets}
