% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_sort_term.R
\name{format_sort_term}
\alias{format_sort_term}
\title{Format character vectors into \code{sort} terms for openFDA API queries}
\usage{
format_sort_term(sort)
}
\arguments{
\item{sort}{A single-length character vector of length 1. If unnamed,
it will be assumed that you have already formatted your search string to
work with the API. If named, the vector will be collapsed to include your
field and sorting choice.}
}
\value{
A character vector of the S3 class \verb{<AsIS>}, with a formatted search
term which can be supplied to \code{openFDA()}.
}
\description{
This function acts as a helper for constructing a sort term in the openFDA
API.
}
\note{
This function does not check that you're providing accurate field names or
search terms. It is up to you to make sure you've provided correctly spelt
fields and search terms.
}
\examples{
# Provide a formatted search string and the function will do no formatting
format_sort_term("openfda.generic_name:asc")

# Provide a named vector and the function will format it for you
format_sort_term(c("openfda.generic_name" = "asc"))

# Errors will be thrown if you supply a bad input
try(format_sort_term("receivedate:no_order"))
try(format_sort_term(c("receivedate" = "ascending")))
}
\seealso{
\itemize{
\item \code{\link[=format_search_term]{format_search_term()}} performs similar formatting for the \code{search}
component of an openFDA query.
\item \code{\link[=I]{I()}} generates vectors with the \verb{<AsIs>} S3 class.
\item \code{\link[httr2:req_url]{httr2::req_url()}} documents why \code{\link[=I]{I()}} is applied to the output of this
function.
}
}
