% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pccs.R
\name{plot.opaGroupComparison}
\alias{plot.opaGroupComparison}
\title{Plot group comparison PCC replicates.}
\usage{
\method{plot}{opaGroupComparison}(x, ...)
}
\arguments{
\item{x}{an object of class "oparandpccs" produced by \code{random_pccs()}}

\item{...}{ignored}
}
\value{
no return value, called for side effects only.
}
\description{
Plot group comparison PCC replicates.
}
\details{
Plot a histogram of PCCs computed from randomly reordered data
used to calculate the chance-value for a group comparison.
}
\examples{
dat <- data.frame(group = c("a", "b", "a", "b"),
                  t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11))
dat$group <- factor(dat$group, levels = c("a", "b"))
h <- hypothesis(1:3)
opamod <- opa(dat[,2:4], h, group = dat$group)
z <- compare_groups(opamod, "a", "b")
plot(z)
}
