% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pccs.R
\name{compare_groups}
\alias{compare_groups}
\title{Calculate the c-value of the difference in PCCs produced by two groups}
\usage{
compare_groups(m, group1, group2, two_tailed)
}
\arguments{
\item{m}{an object of class "opafit" produced by a call to opa().}

\item{group1}{a character string which matches a group level passed to opa().}

\item{group2}{a character string which matches a group level passed to opa().}

\item{two_tailed}{a boolean indicating whether the comparison is two-tailed.}
}
\value{
an object of class "opaGroupComparison".
}
\description{
Calculate the c-value of the difference in PCCs produced by two groups
}
\examples{
dat <- data.frame(group = c("a", "b", "a", "b"),
                  t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11))
dat$group <- factor(dat$group, levels = c("a", "b"))
h <- hypothesis(1:3)
opamod <- opa(dat[,2:4], h, group = dat$group)
compare_groups(opamod, "a", "b")
}
