% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-trunc.R
\name{summary.truncmodel}
\alias{summary.truncmodel}
\title{Summarize Truncated Regression Models}
\usage{
\method{summary}{truncmodel}(object, ...)
}
\arguments{
\item{object}{A model object of class `"truncmodel"` (for truncated models).}

\item{...}{Additional arguments (currently unused).}
}
\value{
Prints a summary table of coefficients, standard errors, z-values, p-values, 
significance codes, and log-likelihood.
}
\description{
Provides a summary of the fitted model, including estimated coefficients, standard errors, 
significance levels, and other relevant statistics.
}
\details{
This function generates a detailed summary of the fitted model, including:
- Estimated coefficients for the rate component (\code{beta}).
- Standard errors.
- z-statistics, associated p-values, and corresponding significance codes.
- Log-likelihood of the fitted model.
}
\examples{
# Example usage
df <- data.frame(x = rnorm(100), y = rpois(100, lambda = 5))
model <- truncreg(y ~ x, df = df, dist = "Poisson")
summary(model)

}
\seealso{
\code{\link{truncreg}} for fitting truncated regression models.
}
