% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataproductfile.R
\docType{class}
\name{DataProductFile-class}
\alias{DataProductFile-class}
\alias{DataProductFile}
\title{DataProductFile class}
\arguments{
\item{dpRunId}{Run Id of a data product request that was run}

\item{index}{Index of this object's file}

\item{baseUrl}{From the Onc class}

\item{token}{From the Onc class
Downloads this data product file

Can poll, wait and retry if the file is not ready to download}

\item{overwrite}{When TRUE, existing files will be overwritten, otherwise they are skipped}

\item{timeout, pollPeriod, outPath, maxRetries}{Same as in the Onc class}

\item{response}{The successful (200) httr response obtained from a download request}
}
\value{
(integer) the final response's HTTP status code
Return the file name from the response

(string) The filename as obtained from the headers
Return information on this download's outcome

(list) A named list with information on the download result
Sets this object's status to 200 (complete)
Used by onc_delivery methods
}
\description{
Encapsulates the download of a single data product file, and the handling
of the server polling and error codes.
}
\section{Fields}{

\describe{
\item{\code{.filters}}{The list of filters to pass to the download API method}

\item{\code{.retries}}{Total count of HTTP requests made by this object}

\item{\code{.status}}{Last request's HTTP status code}

\item{\code{.downloaded}}{TRUE if the file was downloaded from the API}

\item{\code{.baseUrl}}{Same as in the Onc class}

\item{\code{.downloadUrl}}{URL that downloads this file}

\item{\code{.fileName}}{Filename of the file if downloaded & saved}

\item{\code{.fileSize}}{Size in bytes of the file if downloaded & saved}

\item{\code{.runningTime}}{Total time spent running (sec)}

\item{\code{.downloadingTime}}{Total time spend downloading (sec)
Class initializer}
}}


\keyword{internal}
