% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_group}
\alias{svg_group}
\title{Addition of a group element}
\usage{
svg_group(
  svg,
  ...,
  .list = list2(...),
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{...}{a collection of named arguments that consist of presentation
attributes (e.g., \code{stroke = "blue"}) and formulas that represent elements
(e.g, \code{~ svg_rect(., x = 60, y = 60, width = 50, height = 50)}).}

\item{.list}{Allows for the use of a list as an input alternative to \code{...}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_group()} function allows for grouping of several SVG elements. This
is useful if we'd like to pass presentation attributes to several elements
at once.
}
\examples{
if (interactive()) {

# Create an SVG with two rectangles
# contained within a group
SVG(width = 300, height = 300) \%>\%
  svg_group(
    fill = "steelblue", stroke = "red", opacity = 0.5,
    ~ svg_rect(., x = 20, y = 20, width = 50, height = 50),
    ~ svg_rect(., x = 40, y = 40, width = 50, height = 50, fill = "red")
  )

# Create an SVG with two rectangles
# that are nested within two
# different groups
SVG(width = 300, height = 300) \%>\%
  svg_group(
    fill = "green", stroke = "red",
    ~ svg_rect(., x = 30, y = 30, width = 40, height = 50),
    ~ svg_group(.,
      fill = "steelblue", opacity = 0.5,
      ~ svg_rect(., x = 60, y = 60, width = 50, height = 50)
      )
    )
}

}
