% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{flag_underexpressed_features}
\alias{flag_underexpressed_features}
\title{Flag Underexpressed Features in Samples Based on Blank Samples}
\usage{
flag_underexpressed_features(
  data,
  sample_id_col = "sample_id",
  feature_cols,
  threshold = 10
)
}
\arguments{
\item{data}{A tibble containing the MRM transition data.}

\item{sample_id_col}{Name of the column containing sample ID information.}

\item{feature_cols}{A vector of column names representing the features.}

\item{threshold}{A numeric value representing the threshold multiplier (default is 10).}
}
\value{
A tibble with the same dimensions and column names as the input data,
        containing TRUE, FALSE, or NA based on the criteria.
}
\description{
Flags features in samples based on their abundance in blank samples. If a feature is NA in the first blank sample,
all samples for this feature are marked as TRUE. Otherwise, for each sample and feature, if the peak area is at least
10 times the area of the first blank sample, it is marked as TRUE, else FALSE. NA values in the samples remain unchanged.
}
\examples{
\dontrun{
area_data <- tibble::tibble(
  sample_id = c(
    "011_Blank", "012_sample_002", "013_NIST_Plasma", "014_Blank",
    "015_sample_006", "016_sample_003"
  ),
  `2-Deoxyglucose-6-Phosphate_neg` = c(NA, 345423.96, NA, NA, 125889.80, 323818.25),
  `2-Oxoisoleucine_neg` = c(NA, 53004.06, 124669.80, NA, 23650.90, 118364.36),
  `3-(4-Hydroxyphenyl)propionate_neg` = c(NA, 53004.06, 124669.80, NA, 23650.90, 118364.36)
)
flagged_data <- flag_underexpressed_features(
  area_data,
  sample_id_col = "sample_id",
  feature_cols = names(area_data)[-1]
)
print(flagged_data)
}
}
\author{
Yaoxiang Li
}
