% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOOLL-G.R
\name{MOOLLG}
\alias{MOOLLG}
\alias{pmoollg}
\alias{dmoollg}
\alias{qmoollg}
\alias{rmoollg}
\alias{hmoollg}
\title{Marshal-Olkin Odd log-logistic family of distributions (MOOLL-G)}
\usage{
pmoollg(x, alpha = 1, beta = 1, G = pnorm, ...)

dmoollg(x, alpha = 1, beta = 1, G = pnorm, ...)

qmoollg(q, alpha = 1, beta = 1, G = pnorm, ...)

rmoollg(n, alpha = 1, beta = 1, G = pnorm, ...)

hmoollg(x, alpha = 1, beta = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{pmoollg} gives the distribution function,
 \code{dmoollg} gives the density,
 \code{qmoollg} gives the quantile function,
 \code{hmoollg} gives the hazard function and
 \code{rmoollg} generates random variables from the Marshal-Olkin Odd log-logistic family of
 distributions (MOOLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Gleaton et al. (2010) specified by the pdf
\deqn{f=\frac{\alpha\beta\,g\,G^{\alpha-1}\bar{G}^{\alpha-1}}{[G^\alpha+\beta\,\bar{G}^\alpha]^2}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf,  \eqn{\alpha > 0}, the first shape parameter, and \eqn{\beta > 0}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
pmoollg(x)
pmoollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
dmoollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(dmoollg, -3, 3)
qmoollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
rmoollg(n, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
hmoollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hmoollg, -3, 3)
}
\references{
Gleaton, J. U., Lynch, J. D. (2010). Extended generalized loglogistic families of lifetime distributions with an application. J. Probab. Stat.Sci, 8(1), 1-17.
}
