% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_tsfeatures.R
\name{extract_tsfeatures}
\alias{extract_tsfeatures}
\title{Extract features from a collection of time series}
\usage{
extract_tsfeatures(y, normalise = TRUE, width = ifelse(frequency(y) >
  1, frequency(y), 10), window = width)
}
\arguments{
\item{y}{A multivariate time serie}

\item{normalise}{If TRUE, each time series is scaled to be normally distributed with mean 0 and sd 1}

\item{width}{A window size for variance change, level shift and lumpiness}

\item{window}{A window size for KLscore}
}
\value{
An object of class features with the following components:
  \item{mean}{Mean}
  \item{variance}{Variance}
  \item{lumpiness}{Variance of annual variances of remainder}
  \item{lshift}{Level shift using rolling window}
  \item{vchange}{Variance change}
  \item{linearity}{Strength of linearity}
  \item{curvature}{Strength of curvature}
  \item{spikiness}{Strength of spikiness}
  \item{season}{Strength of seasonality}
  \item{peak}{Strength of peaks}
  \item{trough}{Strength of trough}
  \item{BurstinessFF}{Burstiness of time series using Fano Factor}
  \item{minimum}{Minimum value}
  \item{maximum}{Maximum value}
  \item{rmeaniqmean}{Ratio between interquartile mean and the arithmetic mean }
  \item{moment3}{Third moment}
  \item{highlowmu}{Ratio between the means of data that is below and upper the global mean}
}
\description{
This function extract time series features from a collection of time series.
This is a modification oftsmeasures function of anomalous package
package .
}
\examples{
\donttest{
mvtsplot::mvtsplot(anomalous_stream, levels=8, gcol=2, norm="global")
features <- extract_tsfeatures(anomalous_stream[500:550, ])
plot.ts(features[, 1:10])
}

}
\references{
{Hyndman, R. J., Wang, E., & Laptev, N. (2015). Large-scale unusual time series detection.
In 2015 IEEE International Conference on Data Mining Workshop (ICDMW), (pp. 1616-1619). IEEE.}\cr

{Fulcher, B. D. (2012). Highly comparative time-series analysis. PhD thesis, University of Oxford.}
}
\seealso{
\code{\link{find_odd_streams}}, \code{\link{get_pc_space}},
\code{\link{set_outlier_threshold}}, \code{\link{gg_featurespace}}
}
