% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter_details.R
\name{set_meter_details}
\alias{set_meter_details}
\title{Set the details for your gas/electricity meter}
\usage{
set_meter_details(
  meter_type = c("electricity", "gas"),
  mpan_mprn = NULL,
  serial_number = NULL
)
}
\arguments{
\item{meter_type}{Type of meter-point, electricity or gas}

\item{mpan_mprn}{The electricity meter-point's MPAN or gas meter-point’s
MPRN.}

\item{serial_number}{The meter's serial number.}
}
\value{
No return value, called for side effects.
}
\description{
Set the details for your gas/electricity meter. These will be
stored as environment variables. You should add:
\itemize{
\item \verb{OCTOPUSR_MPAN = <electric MPAN>}
\item \verb{OCTOPUSR_MPRN = <gas MPRN>}
\item \verb{OCTOPUSR_ELEC_SERIAL_NUM = <electric serial number>}
\item \verb{OCTOPUSR_GAS_SERIAL_NUM = <gas serial number>}
to your \code{.Renviron} otherwise you will have to call this function every
session. You can find your meter details (MPAN/MPRN and serial number(s)) on
the \href{https://octopus.energy/dashboard/developer/}{developer dashboard}.
}
}
