% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_ordered_data}
\alias{generate_ordered_data}
\title{Generate Ordered Data}
\usage{
generate_ordered_data(n)
}
\arguments{
\item{n}{Sample size.}
}
\value{
A list storing a data frame with the observed data, a matrix of true conditional probabilities, 
and a matrix of true marginal effects at the mean of the covariates.
}
\description{
Generate a synthetic data set with an ordered non-numeric outcome, together with conditional probabilities and covariates' marginal effects.
}
\details{
First, a latent outcome is generated as follows:

\deqn{Y_i^* = g ( X_i ) + \epsilon_i}

with:

\deqn{g ( X_i ) = X_i^T \beta}

\deqn{X_i := (X_{i, 1}, X_{i, 2}, X_{i, 3}, X_{i, 4}, X_{i, 5}, X_{i, 6})}

\deqn{X_{i, 1}, X_{i, 3}, X_{i, 5} \sim \mathcal{N} \left( 0, 1 \right)}

\deqn{X_{i, 2}, X_{i, 4}, X_{i, 6} \sim \textit{Bernoulli} \left( 0, 1 \right)}

\deqn{\beta = \left( 1, 1, 1/2, 1/2, 0, 0 \right)}

\deqn{\epsilon_i \sim logistic (0, 1)}

Second, the observed outcomes are obtained by discretizing the latent outcome into three classes using uniformly spaced threshold parameters.

Third, the conditional probabilities and the covariates' marginal effects at the mean are generated using standard textbook formulas. Marginal
effects are approximated using a sample of 1,000,000 observations.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_ordered_data(1000)

head(data$true_probs)
data$me_at_mean

sample <- data$sample
Y <- sample$Y
X <- sample[, -1]

## Fit ocf.
forests <- ocf(Y, X)}
  
}
\references{
\itemize{
  \item Di Francesco, R. (2025). Ordered Correlation Forest. Econometric Reviews, 1–17. \doi{10.1080/07474938.2024.2429596}.
}
}
\seealso{
\code{\link{ocf}}
}
\author{
Riccardo Di Francesco
}
