% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swZ}
\alias{swZ}
\title{Vertical Coordinate}
\usage{
swZ(
  pressure,
  latitude = 45,
  eos = getOption("oceEOS", default = "gsw"),
  debug = getOption("oceDebug")
)
}
\arguments{
\item{pressure}{either pressure (dbar), in which case \code{latitude} must also
be given, or a \code{ctd} object, in which case \code{latitude} will be inferred
from the object.}

\item{latitude}{numeric value for latitude in degrees North.}

\item{eos}{character value indicating the formulation to be used, either
\code{"unesco"} or \code{"gsw"}.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Compute height above the surface. This is the negative of depth,
and so is defined simply in terms of \code{\link[=swDepth]{swDepth()}}.
}
\seealso{
Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT48}()},
\code{\link{T90fromT68}()},
\code{\link{computableWaterProperties}()},
\code{\link{locationForGsw}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlpha}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSR}()},
\code{\link{swSTrho}()},
\code{\link{swSigma}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaT}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swSpiciness0}()},
\code{\link{swSpiciness1}()},
\code{\link{swSpiciness2}()},
\code{\link{swSstar}()},
\code{\link{swTFreeze}()},
\code{\link{swTSrho}()},
\code{\link{swThermalConductivity}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()}
}
\concept{functions that calculate seawater properties}
