% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swSR}
\alias{swSR}
\title{Seawater Reference Salinity (GSW Formulation)}
\usage{
swSR(salinity)
}
\arguments{
\item{salinity}{either practical salinity or an \code{oce} object
that holds salinity in its data slot.}
}
\value{
Reference Salinity, SR, in \eqn{g/kg}{g/kg}.
}
\description{
Compute seawater Reference Salinity (SR), according to the GSW/TEOS-10
formulation with \code{\link[gsw:gsw_SR_from_SP]{gsw::gsw_SR_from_SP()}} in the \CRANpkg{gsw} package.
}
\examples{
SR <- swSR(35.0) # 35.16504

}
\references{
McDougall, T.J. and P.M. Barker, 2011: Getting started with
TEOS-10 and the Gibbs Seawater (GSW) Oceanographic Toolbox, 28pp.,
SCOR/IAPSO WG127, ISBN 978-0-646-55621-5.
}
\seealso{
For some objects, SR may also be recovered by indexing as e.g.
\code{ctd[["SR"]]}.

Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT48}()},
\code{\link{T90fromT68}()},
\code{\link{computableWaterProperties}()},
\code{\link{locationForGsw}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlpha}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSTrho}()},
\code{\link{swSigma}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaT}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swSpiciness0}()},
\code{\link{swSpiciness1}()},
\code{\link{swSpiciness2}()},
\code{\link{swSstar}()},
\code{\link{swTFreeze}()},
\code{\link{swTSrho}()},
\code{\link{swThermalConductivity}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()},
\code{\link{swZ}()}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
